/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageDownloadServlet
extends HttpServlet {
    private static final String ID_PARAM = "id";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PageDownloadServlet.class.getName());
    private static final long serialVersionUID = 7203686892997001991L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String pageIDStr = request.getParameter(ID_PARAM);
        long pageId = 0L;
        if (pageIDStr == null) {
            throw new ServletException("The ID parameter is mandatory.");
        }
        pageId = Long.parseLong(pageIDStr);
        APISession apiSession = (APISession)request.getSession().getAttribute("apiSession");
        OutputStream out = null;
        try {
            PageAPI pageAPI = this.getPageAPI(apiSession);
            Page page = pageAPI.getPage(pageId);
            byte[] pageContent = pageAPI.getPageContent(pageId);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            String encodedfileName = URLEncoder.encode(page.getContentName(), StandardCharsets.UTF_8);
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null && userAgent.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedfileName);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedfileName.replaceAll("\\_", " ") + "\"; filename*=UTF-8''" + encodedfileName);
            }
            out = response.getOutputStream();
            if (pageContent == null) {
                response.setContentLength(0);
            } else {
                response.setContentLength(pageContent.length);
            }
            out.write(pageContent);
        }
        catch (InvalidSessionException e) {
            String message = "Session expired. Please login again.";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Session expired. Please login again.", (Throwable)e);
            }
            try {
                out.write("Session expired. Please login again.".getBytes());
            }
            catch (IOException e1) {
                throw new ServletException((Throwable)e1);
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            try {
                out.write("An exception occured. Please contact an administrator".getBytes());
            }
            catch (IOException e1) {
                throw new ServletException((Throwable)e1);
            }
        }
    }

    private PageAPI getPageAPI(APISession apiSession) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getCustomPageAPI((APISession)apiSession);
    }
}

