/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.page.PageNotFoundException;
import org.bonitasoft.web.extension.page.PageResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageResourceProviderImpl
implements PageResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PageResourceProviderImpl.class.getName());
    private static final String VERSION_FILENAME = "VERSION";
    protected static final String THEME_RESOURCE_SERVLET_NAME = "themeResource";
    protected static final String PORTAL_THEME_NAME = "portal";
    protected static final String BONITA_THEME_CSS_FILENAME = "bonita.css";
    protected static String productVersion;
    protected static final String VERSION_PARAM = "v";
    protected static final String LOCATION_PARAM = "location";
    protected static final String THEME_PARAM = "theme";
    private final String fullPageName;
    protected String pageName;
    protected File pageDirectory;
    private ClassLoader resourceClassLoader;
    private File pageTempFile = null;
    private final Long pageId;

    public PageResourceProviderImpl(String pageName) {
        this(pageName, null, null, true);
    }

    public PageResourceProviderImpl(Page page) {
        this(page.getName(), page.getId(), page.getProcessDefinitionId(), true);
    }

    private PageResourceProviderImpl(String pageName, Long pageId, Long processDefinitionId, boolean buildPageTempFile) {
        this.pageName = pageName;
        this.pageId = pageId;
        this.fullPageName = this.buildFullPageName(pageName, processDefinitionId);
        this.pageDirectory = this.buildPageDirectory(this.fullPageName);
        if (buildPageTempFile) {
            this.buildPageTempDirectory(this.fullPageName);
            this.pageTempFile = this.buildPageTempFile(this.fullPageName);
        }
    }

    private String buildFullPageName(String pageName, Long processDefinitionId) {
        StringBuilder builder = new StringBuilder();
        if (processDefinitionId != null) {
            builder.append("p").append(processDefinitionId).append("_");
        }
        builder.append(pageName);
        return builder.toString();
    }

    protected void buildPageTempDirectory(String fullPageName) {
        new File(WebBonitaConstantsUtils.getTenantInstance().getTempFolder(), fullPageName);
    }

    protected File buildPageTempFile(String fullPageName) {
        return new File(WebBonitaConstantsUtils.getTenantInstance().getTempFolder(), fullPageName + ".zip");
    }

    protected File buildPageDirectory(String fullPageName) {
        return new File(WebBonitaConstantsUtils.getTenantInstance().getPagesFolder(), fullPageName);
    }

    public InputStream getResourceAsStream(String resourceName) throws FileNotFoundException {
        return new FileInputStream(this.getResourceAsFile(resourceName));
    }

    public File getResourceAsFile(String resourceName) {
        return new File(this.pageDirectory, resourceName);
    }

    public String getResourceURL(String resourceName) {
        return resourceName + "?v=" + productVersion;
    }

    public String getBonitaThemeCSSURL() {
        return "themeResource?theme=portal&location=bonita.css&v=" + productVersion;
    }

    public File getPageDirectory() {
        return this.pageDirectory;
    }

    public File getTempPageFile() {
        return this.pageTempFile;
    }

    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public ResourceBundle getResourceBundle(String name, Locale locale) {
        return ResourceBundle.getBundle(name, locale, this.resourceClassLoader);
    }

    public String getPageName() {
        return this.pageName;
    }

    public Page getPage(PageAPI pageAPI) throws PageNotFoundException {
        if (this.pageId != null) {
            return pageAPI.getPage(this.pageId.longValue());
        }
        return pageAPI.getPageByName(this.getPageName());
    }

    public String getFullPageName() {
        return this.fullPageName;
    }

    static {
        InputStream versionStream = PageResourceProviderImpl.class.getClassLoader().getResourceAsStream(VERSION_FILENAME);
        if (versionStream != null) {
            try {
                productVersion = IOUtils.toString((InputStream)versionStream);
            }
            catch (Exception e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Unable to read the file VERSION", (Throwable)e);
                }
                productVersion = "";
            }
            finally {
                block14: {
                    try {
                        versionStream.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isWarnEnabled()) break block14;
                        LOGGER.warn("Unable to close the input stream for file VERSION", (Throwable)e);
                    }
                }
            }
        } else {
            productVersion = "";
        }
    }
}

