/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.bonitasoft.console.common.server.utils.BPMEngineAPIUtil;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.FormsResourcesUtils;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 5209516978177786895L;
    protected static final String PROCESS_ID_PARAM = "process";
    protected static final String INSTANCE_ID_PARAM = "instance";
    protected static final String TASK_ID_PARAM = "task";
    protected static final String DOCUMENT_ID_PARAM = "document";
    protected static final String FILE_PATH_PARAM = "filePath";
    protected static final String FILE_NAME_PARAM = "fileName";
    protected static final String RESOURCE_FILE_NAME_PARAM = "resourceFileName";
    protected static final String API_SESSION_PARAM_KEY = "apiSession";
    protected static final String BUSINESS_ARCHIVE_RESOURCES_DIRECTORY = "documents";
    protected static final String CONTENT_STORAGE_ID_PARAM = "contentStorageId";
    protected final BPMEngineAPIUtil bpmEngineAPIUtil = new BPMEngineAPIUtil();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDownloadServlet.class.getName());

    /*
     * Unable to fully structure code
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block46: {
            filePath = request.getParameter("filePath");
            fileName = request.getParameter("fileName");
            resourcePath = request.getParameter("resourceFileName");
            documentId = request.getParameter("document");
            contentStorageId = request.getParameter("contentStorageId");
            apiSession = (APISession)request.getSession().getAttribute("apiSession");
            content = null;
            if (filePath != null) {
                if (DocumentDownloadServlet.LOGGER.isDebugEnabled()) {
                    DocumentDownloadServlet.LOGGER.debug("attachmentPath: " + filePath);
                }
                tempFolderAccessor = new BonitaHomeFolderAccessor();
                try {
                    fileContent = tempFolderAccessor.retrieveUploadedTempContent(FilenameUtils.separatorsToSystem((String)filePath));
                    if (fileName == null) {
                        fileName = fileContent.getFileName();
                    }
                    inputStream = fileContent.getInputStream();
                    try {
                        content = this.getFileContent(inputStream, filePath, fileContent.getSize());
                        break block46;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (BonitaException e) {
                    throw new ServletException(e.getMessage());
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if (fileName != null && contentStorageId != null) {
                try {
                    content = this.bpmEngineAPIUtil.getProcessAPI(apiSession).getDocumentContent(contentStorageId);
                }
                catch (Exception e) {
                    errorMessage = "Error while retrieving the document  with content storage ID " + contentStorageId + " from the engine.";
                    if (DocumentDownloadServlet.LOGGER.isErrorEnabled()) {
                        DocumentDownloadServlet.LOGGER.error(errorMessage, (Throwable)e);
                    }
                    throw new ServletException(errorMessage, (Throwable)e);
                }
            }
            if (documentId != null) {
                try {
                    processAPI = this.bpmEngineAPIUtil.getProcessAPI(apiSession);
                    try {
                        document = processAPI.getDocument(Long.valueOf(documentId).longValue());
                        fileName = document.getContentFileName();
                        contentStorageId = document.getContentStorageId();
                    }
                    catch (DocumentNotFoundException dnfe) {
                        archivedDocument = processAPI.getArchivedVersionOfProcessDocument(Long.valueOf(documentId).longValue());
                        fileName = archivedDocument.getContentFileName();
                        contentStorageId = archivedDocument.getContentStorageId();
                    }
                    if (contentStorageId == null || contentStorageId.isEmpty()) ** GOTO lbl97
                    content = processAPI.getDocumentContent(contentStorageId);
                }
                catch (Exception e) {
                    errorMessage = "Error while retrieving the document  with ID " + documentId + " from the engine.";
                    if (DocumentDownloadServlet.LOGGER.isErrorEnabled()) {
                        DocumentDownloadServlet.LOGGER.error(errorMessage, (Throwable)e);
                    }
                    throw new ServletException(errorMessage, (Throwable)e);
                }
            } else if (resourcePath != null) {
                processIDStr = request.getParameter("process");
                instanceIDStr = request.getParameter("instance");
                taskIdStr = request.getParameter("task");
                processDefinitionID = -1L;
                try {
                    if (processIDStr != null) {
                        processDefinitionID = Long.parseLong(processIDStr);
                    } else if (taskIdStr != null) {
                        processDefinitionID = this.getProcessDefinitionIDFromActivityInstanceID(apiSession, Long.parseLong(taskIdStr));
                    } else if (instanceIDStr != null) {
                        processDefinitionID = this.getProcessDefinitionIDFromProcessInstanceID(apiSession, Long.parseLong(instanceIDStr));
                    } else {
                        errorMessage = "Error while retrieving the resource " + resourcePath + " : Either a process, instance or task is required in the URL";
                        if (DocumentDownloadServlet.LOGGER.isErrorEnabled()) {
                            DocumentDownloadServlet.LOGGER.error(errorMessage);
                        }
                        throw new ServletException(errorMessage);
                    }
                    processDeployementDate = this.getMigrationDate(apiSession, processDefinitionID);
                    if (processDeployementDate == null) {
                        processDeployementDate = this.getProcessDefinitionDate(apiSession, processDefinitionID);
                    }
                    if (!(resource = new File(processDir = FormsResourcesUtils.getApplicationResourceDir(apiSession, processDefinitionID, processDeployementDate), "documents" + File.separator + resourcePath)).exists()) {
                        errorMessage = "The target resource does not exist " + resource.getAbsolutePath();
                        if (DocumentDownloadServlet.LOGGER.isErrorEnabled()) {
                            DocumentDownloadServlet.LOGGER.error(errorMessage);
                        }
                        throw new IOException(errorMessage);
                    }
                    fileName = resource.getName();
                    resourceInputStream = new FileInputStream(resource);
                    content = this.getFileContent(resourceInputStream, fileName, resource.length());
                }
                catch (Exception e) {
                    errorMessage = "Error while retrieving the resource " + resourcePath;
                    if (DocumentDownloadServlet.LOGGER.isErrorEnabled()) {
                        DocumentDownloadServlet.LOGGER.error(errorMessage, (Throwable)e);
                    }
                    throw new ServletException(errorMessage, (Throwable)e);
                }
            } else {
                errorMessage = "Error while getting the file. either a document, a filePath or a resourcePath parameter is required.";
                if (DocumentDownloadServlet.LOGGER.isErrorEnabled()) {
                    DocumentDownloadServlet.LOGGER.error("Error while getting the file. either a document, a filePath or a resourcePath parameter is required.");
                }
                throw new ServletException("Error while getting the file. either a document, a filePath or a resourcePath parameter is required.");
            }
        }
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        try {
            encodedfileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
            userAgent = request.getHeader("User-Agent");
            if (userAgent != null && userAgent.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedfileName.replace("+", "%20"));
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedfileName.replaceAll("\\+", " ") + "\"; filename*=UTF-8''" + encodedfileName.replace("+", "%20"));
            }
            out = response.getOutputStream();
            if (content == null) {
                response.setContentLength(0);
            } else {
                response.setContentLength(content.length);
                out.write(content);
            }
        }
        catch (IOException e) {
            if (DocumentDownloadServlet.LOGGER.isErrorEnabled()) {
                DocumentDownloadServlet.LOGGER.error("Error while generating the response.", (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
    }

    protected byte[] getFileContent(InputStream inputStream, String filePath, long size) throws ServletException, IOException {
        byte[] content;
        int fileLength = 0;
        if (size > Integer.MAX_VALUE) {
            throw new ServletException("file " + filePath + " too big !");
        }
        fileLength = (int)size;
        try {
            byte[] fileContent = new byte[fileLength];
            try {
                int read;
                int offset = 0;
                int length = fileLength;
                while (length > 0 && (read = inputStream.read(fileContent, offset, length)) > 0) {
                    length -= read;
                    offset += read;
                }
                content = fileContent;
            }
            catch (FileNotFoundException e) {
                String errorMessage = "Error while getting the attachment. The file " + filePath + " does not exist.";
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error(errorMessage, (Throwable)e);
                }
                throw new ServletException(errorMessage, (Throwable)e);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            String errorMessage = "Error while reading attachment (file  : " + filePath;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(errorMessage, (Throwable)e);
            }
            throw new ServletException(errorMessage, (Throwable)e);
        }
        return content;
    }

    protected long getProcessDefinitionIDFromActivityInstanceID(APISession session, long activityInstanceID) throws BonitaException {
        ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)session);
        return processAPI.getProcessDefinitionIdFromActivityInstanceId(activityInstanceID);
    }

    protected long getProcessDefinitionIDFromProcessInstanceID(APISession session, long processInstanceID) throws BonitaException {
        ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)session);
        return processAPI.getProcessDefinitionIdFromProcessInstanceId(processInstanceID);
    }

    protected Date getMigrationDate(APISession session, long processDefinitionID) throws BonitaException {
        ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)session);
        ProcessDeploymentInfo processDeploymentInfo = processAPI.getProcessDeploymentInfo(processDefinitionID);
        Date migrationDate = null;
        if (!processDeploymentInfo.getDeploymentDate().equals(processDeploymentInfo.getLastUpdateDate())) {
            migrationDate = processDeploymentInfo.getLastUpdateDate();
        }
        return migrationDate;
    }

    protected Date getProcessDefinitionDate(APISession session, long processDefinitionID) throws BonitaException {
        ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)session);
        return processAPI.getProcessDeploymentInfo(processDefinitionID).getDeploymentDate();
    }
}

