/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.console.common.server.servlet.ResourceLocationReader;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = -2103038794535737881L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ResourceServlet.class.getName());
    protected ResourceLocationReader resourceLocationReader = new ResourceLocationReader();

    protected abstract String getResourceParameterName();

    protected abstract String getDefaultResourceName();

    protected abstract File getResourcesParentFolder();

    protected abstract String getSubFolderName();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileName = this.resourceLocationReader.getResourceLocationFromRequest(request);
        String resourceName = request.getParameter(this.getResourceParameterName());
        if (resourceName == null) {
            resourceName = this.getDefaultResourceName();
        }
        try {
            this.getResourceFile(response, resourceName, fileName);
        }
        catch (UnsupportedEncodingException e) {
            String errorMessage = "UnsupportedEncodingException :" + e;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(errorMessage);
            }
            throw new ServletException(errorMessage);
        }
    }

    protected void getResourceFile(HttpServletResponse response, String resourceName, String fileName) throws ServletException, IOException {
        if (resourceName == null) {
            String errorMessage = "Error while using the servlet to get a resource: the parameter " + this.getResourceParameterName() + " is null.";
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(errorMessage);
            }
            throw new ServletException(errorMessage);
        }
        if (fileName == null) {
            String errorMessage = "Error while using the servlet to get a resource: the parameter location is null.";
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Error while using the servlet to get a resource: the parameter location is null.");
            }
            throw new ServletException("Error while using the servlet to get a resource: the parameter location is null.");
        }
        resourceName = URLDecoder.decode(resourceName, "UTF-8");
        fileName = URLDecoder.decode(fileName, "UTF-8");
        response.setCharacterEncoding("UTF-8");
        File resourcesParentFolder = this.getResourcesFolder();
        String subFolderName = this.getSubFolderName();
        Object subFolderSuffix = subFolderName != null ? File.separator + subFolderName : "";
        try {
            String contentType;
            File resourceFolder = new File(resourcesParentFolder, resourceName + (String)subFolderSuffix);
            File file = new File(resourceFolder, fileName);
            BonitaHomeFolderAccessor tenantFolder = new BonitaHomeFolderAccessor();
            if (!tenantFolder.isInFolder(resourceFolder, resourcesParentFolder)) {
                throw new ServletException("For security reasons, access to this file paths " + resourceFolder.getAbsolutePath() + " is restricted.");
            }
            if (!tenantFolder.isInFolder(file, resourceFolder)) {
                throw new ServletException("For security reasons, access to this file paths " + file.getAbsolutePath() + " is restricted.");
            }
            String lowerCaseFileName = fileName.toLowerCase();
            if (lowerCaseFileName.endsWith(".jpg")) {
                contentType = "image/jpeg";
            } else if (lowerCaseFileName.endsWith(".jpeg")) {
                contentType = "image/jpeg";
            } else if (lowerCaseFileName.endsWith(".gif")) {
                contentType = "image/gif";
            } else if (lowerCaseFileName.endsWith(".png")) {
                contentType = "image/png";
            } else if (lowerCaseFileName.endsWith(".css") || lowerCaseFileName.endsWith(".less")) {
                contentType = "text/css";
            } else if (lowerCaseFileName.endsWith(".js")) {
                contentType = "application/x-javascript";
            } else if (lowerCaseFileName.endsWith(".html")) {
                contentType = "text/html; charset=UTF-8";
            } else if (lowerCaseFileName.endsWith(".htc")) {
                contentType = "text/x-component";
            } else if (lowerCaseFileName.endsWith(".svg")) {
                contentType = "image/svg+xml";
            } else if (lowerCaseFileName.endsWith(".eot")) {
                contentType = "application/vnd.ms-fontobject";
            } else if (lowerCaseFileName.endsWith(".woff")) {
                contentType = "application/x-font-woff";
            } else if (lowerCaseFileName.endsWith(".ttf")) {
                contentType = "application/x-font-ttf";
            } else if (lowerCaseFileName.endsWith(".otf")) {
                contentType = "application/x-font-opentype";
            } else {
                MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
                contentType = mimetypesFileTypeMap.getContentType(file);
            }
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            byte[] content = FileUtils.readFileToByteArray((File)file);
            response.setContentType(contentType);
            response.setContentLength(content.length);
            response.setBufferSize(content.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(content, 0, content.length);
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(e.getMessage());
            }
            response.sendError(404);
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error while generating the response.", (Throwable)e);
            }
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    protected File getResourcesFolder() throws ServletException {
        try {
            return this.getResourcesParentFolder();
        }
        catch (RuntimeException e) {
            String errorMessage = "Error while using the servlet to get parent folder.";
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Error while using the servlet to get parent folder.");
            }
            throw new ServletException("Error while using the servlet to get parent folder.");
        }
    }
}

