/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.console.common.server.preferences.properties.ConsoleProperties;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.servlet.FileUploadServlet;
import org.bonitasoft.engine.session.APISession;

public class TenantFileUploadServlet
extends FileUploadServlet {
    private static final long serialVersionUID = 58370675886169565L;

    @Override
    protected void defineUploadDirectoryPath(HttpServletRequest request) {
        this.setUploadDirectoryPath(WebBonitaConstantsUtils.getTenantInstance().getTempFolder().getPath());
    }

    protected APISession getAPISession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (APISession)session.getAttribute("apiSession");
    }

    @Override
    protected void setUploadMaxSize(ServletFileUpload serviceFileUpload, HttpServletRequest request) {
        if (this.checkUploadedImageSize) {
            serviceFileUpload.setFileSizeMax(this.getConsoleProperties().getImageMaxSizeInKB() * 1024L);
        } else if (this.checkUploadedFileSize) {
            serviceFileUpload.setFileSizeMax(this.getConsoleProperties().getMaxSize() * 0x100000L);
        } else {
            serviceFileUpload.setFileSizeMax(Integer.MAX_VALUE);
        }
    }

    protected ConsoleProperties getConsoleProperties() {
        return PropertiesFactory.getConsoleProperties();
    }
}

