/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.console.common.server.utils.IconDescriptor;
import org.bonitasoft.console.common.server.utils.UnauthorizedFolderException;
import org.bonitasoft.engine.api.PlatformAPIAccessor;
import org.bonitasoft.engine.api.TemporaryContentAPI;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.io.TemporaryFileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BonitaHomeFolderAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BonitaHomeFolderAccessor.class.getName());

    @Deprecated(since="9.0.0")
    public File getTempFile(String tempFileKey) throws IOException {
        try {
            FileContent fileContent = this.retrieveUploadedTempContent(tempFileKey);
            File file = this.makeUniqueFilename(fileContent.getFileName());
            try (InputStream inputStream = fileContent.getInputStream();){
                Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            return file;
        }
        catch (BonitaException e) {
            throw new IOException(e);
        }
    }

    public FileContent retrieveUploadedTempContent(String tempFileKey) throws BonitaException {
        TemporaryContentAPI temporaryContentAPI = PlatformAPIAccessor.getTemporaryContentAPI();
        try {
            return temporaryContentAPI.retrieveTempFile(tempFileKey);
        }
        catch (TemporaryFileNotFoundException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to find temporary file with key " + tempFileKey);
            }
            throw e;
        }
        catch (BonitaRuntimeException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to retrieve temporary file with key " + tempFileKey);
            }
            throw new BonitaException((Throwable)e);
        }
    }

    public void removeUploadedTempContent(String tempFileKey) {
        block2: {
            try {
                TemporaryContentAPI temporaryContentAPI = PlatformAPIAccessor.getTemporaryContentAPI();
                temporaryContentAPI.removeTempFile(tempFileKey);
            }
            catch (BonitaException | BonitaRuntimeException e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Unable to remove temporary file with key " + tempFileKey + " If still present, it will be cleaned by the scheduler.");
            }
        }
    }

    protected File makeUniqueFilename(String fileName) throws IOException {
        File uploadedFile = File.createTempFile("tmp_", this.getExtension(fileName), this.getBonitaTenantConstantUtil().getTempFolder());
        uploadedFile.deleteOnExit();
        return uploadedFile;
    }

    protected String getExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }

    public WebBonitaConstantsUtils getBonitaTenantConstantUtil() {
        return WebBonitaConstantsUtils.getTenantInstance();
    }

    public boolean isInTempFolder(File file, WebBonitaConstantsUtils webBonitaConstantsUtils) throws IOException {
        return this.isInFolder(file, webBonitaConstantsUtils.getTempFolder());
    }

    public boolean isInFolder(File file, File parentFolder) throws IOException {
        try {
            this.verifyFolderAuthorization(file, parentFolder);
        }
        catch (UnauthorizedFolderException e) {
            return false;
        }
        return true;
    }

    private void verifyFolderAuthorization(File file, File parentFolder) throws IOException {
        try {
            if (!file.getCanonicalPath().startsWith(parentFolder.getCanonicalPath())) {
                throw new UnauthorizedFolderException("Unauthorized access to the file " + file.getPath());
            }
        }
        catch (UnauthorizedFolderException e) {
            String errorMessage = "Unauthorized access to the file " + file.getAbsolutePath() + ". For security reasons, access to paths other than " + parentFolder.getAbsolutePath() + " is restricted.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(errorMessage, (Throwable)e);
            }
            throw e;
        }
    }

    public IconDescriptor getIconFromFileSystem(String iconKey) {
        try {
            TemporaryContentAPI temporaryContentAPI = PlatformAPIAccessor.getTemporaryContentAPI();
            FileContent fileContent = temporaryContentAPI.retrieveTempFile(iconKey);
            return new IconDescriptor(fileContent.getFileName(), IOUtils.toByteArray((InputStream)fileContent.getInputStream()));
        }
        catch (TemporaryFileNotFoundException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to find temporary file with key " + iconKey);
            }
            throw new RuntimeException(e);
        }
        catch (IOException | BonitaException e) {
            throw new RuntimeException(e);
        }
    }
}

