/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.livingapps;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.page.CustomPageRequestModifier;
import org.bonitasoft.console.common.server.page.PageRenderer;
import org.bonitasoft.console.common.server.page.ResourceRenderer;
import org.bonitasoft.console.common.server.page.extension.PageResourceProviderImpl;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.page.PageNotFoundException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.livingapps.ApplicationModel;
import org.bonitasoft.livingapps.ApplicationModelFactory;
import org.bonitasoft.livingapps.exception.CreationException;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;

public class ApplicationRouter {
    private final ApplicationModelFactory applicationModelFactory;
    protected final CustomPageRequestModifier customPageRequestModifier = new CustomPageRequestModifier();
    protected final String THEME_TOKEN = "theme";

    public ApplicationRouter(ApplicationModelFactory applicationModelFactory) {
        this.applicationModelFactory = applicationModelFactory;
    }

    public void route(HttpServletRequest hsRequest, HttpServletResponse hsResponse, APISession session, PageRenderer pageRenderer, ResourceRenderer resourceRenderer, BonitaHomeFolderAccessor bonitaHomeFolderAccessor) throws CreationException, BonitaException, IOException, ServletException, IllegalAccessException, InstantiationException {
        ParsedRequest parsedRequest = this.parse(hsRequest.getContextPath(), hsRequest.getServletPath(), hsRequest.getPathInfo());
        List<String> pathSegments = resourceRenderer.getPathSegments(hsRequest.getPathInfo());
        if (pathSegments.isEmpty()) {
            hsResponse.sendError(404, "The name of the application is required.");
            return;
        }
        if ("API".equals(parsedRequest.getPageToken())) {
            String apiPath = "/" + this.getResourcePathWithoutApplicationToken(hsRequest.getPathInfo(), parsedRequest.getApplicationName());
            this.customPageRequestModifier.forwardIfRequestIsAuthorized(hsRequest, hsResponse, "/API", apiPath);
        } else if ("GET".equals(hsRequest.getMethod())) {
            this.displayPageOrResource(hsRequest, hsResponse, session, pageRenderer, resourceRenderer, bonitaHomeFolderAccessor, parsedRequest, pathSegments);
        } else {
            hsResponse.setStatus(405);
            hsResponse.flushBuffer();
        }
    }

    protected void displayPageOrResource(HttpServletRequest hsRequest, HttpServletResponse hsResponse, APISession session, PageRenderer pageRenderer, ResourceRenderer resourceRenderer, BonitaHomeFolderAccessor bonitaHomeFolderAccessor, ParsedRequest parsedRequest, List<String> pathSegments) throws IOException, InstantiationException, IllegalAccessException, BonitaException, CreationException {
        ApplicationModel application = this.applicationModelFactory.createApplicationModel(parsedRequest.getApplicationName());
        if (!application.hasProfileMapped()) {
            hsResponse.sendError(404, "No profile mapped to living application");
            return;
        }
        if (parsedRequest.getPageToken() == null) {
            hsResponse.sendRedirect(this.buildHomePageRouteWithParams(hsRequest, application.getApplicationHomePage()));
            return;
        }
        if (this.isApplicationPageRequest(pathSegments)) {
            if (!application.hasPage(parsedRequest.getPageToken())) {
                hsResponse.sendError(404, "There is no page " + parsedRequest.getPageToken() + " in the application " + parsedRequest.getApplicationName());
                return;
            }
            if (!application.authorize(session)) {
                hsResponse.sendError(403, "Unauthorized access for the page " + parsedRequest.getPageToken() + " of the application " + parsedRequest.getApplicationName());
                return;
            }
            pageRenderer.displayCustomPage(hsRequest, hsResponse, session, application.getApplicationLayoutName());
        } else {
            File resourceFile = this.getResourceFile(pageRenderer, hsRequest.getPathInfo(), pathSegments, application, bonitaHomeFolderAccessor);
            pageRenderer.ensurePageFolderIsPresent(session, pageRenderer.getPageResourceProvider(this.getPageName(pathSegments, application)));
            resourceRenderer.renderFile(hsRequest, hsResponse, resourceFile);
        }
    }

    private String buildHomePageRouteWithParams(HttpServletRequest hsRequest, String applicationHomePage) {
        StringBuilder routeWithParamsBuilder = new StringBuilder(applicationHomePage);
        if (!StringUtil.isBlank(hsRequest.getQueryString())) {
            routeWithParamsBuilder.append("?").append(hsRequest.getQueryString());
        }
        return routeWithParamsBuilder.toString();
    }

    private boolean isApplicationPageRequest(List<String> pathSegments) {
        return pathSegments.size() == 2;
    }

    private File getResourceFile(PageRenderer pageRenderer, String resourcePath, List<String> pathSegments, ApplicationModel application, BonitaHomeFolderAccessor bonitaHomeFolderAccessor) throws IOException, BonitaException {
        String pageName = this.getPageName(pathSegments, application);
        PageResourceProviderImpl pageResourceProvider = pageRenderer.getPageResourceProvider(pageName);
        File resourceFile = new File(pageResourceProvider.getPageDirectory(), "resources" + File.separator + this.getResourcePath(resourcePath, pathSegments.get(0), pathSegments.get(1)));
        if (!bonitaHomeFolderAccessor.isInFolder(resourceFile, pageResourceProvider.getPageDirectory())) {
            throw new BonitaException("Unauthorized access to the file " + resourcePath);
        }
        return resourceFile;
    }

    private String getPageName(List<String> pathSegments, ApplicationModel application) throws PageNotFoundException {
        String pageName = "theme".equals(pathSegments.get(1)) ? application.getApplicationThemeName() : application.getApplicationLayoutName();
        return pageName;
    }

    private String getResourcePath(String fullResourcePath, String applicationName, String pageToken) {
        String resourcePath = this.getResourcePathWithoutApplicationToken(fullResourcePath, applicationName);
        resourcePath = this.getResourcePathWithoutPageToken(resourcePath, pageToken);
        return resourcePath;
    }

    private String getResourcePathWithoutApplicationToken(String resourcePath, String applicationName) {
        return resourcePath.substring(applicationName.length() + 2);
    }

    private String getResourcePathWithoutPageToken(String resourcePath, String pageToken) {
        return resourcePath.substring(pageToken.length() + 1);
    }

    private ParsedRequest parse(String context, String servletPath, String pathInfo) {
        Pattern pattern = Pattern.compile("^" + context + "/apps/(.*)$");
        Matcher matcher = pattern.matcher(context + servletPath + pathInfo);
        if (!matcher.find()) {
            throw new RuntimeException("URI badly formed.");
        }
        String[] fragments = matcher.group(1).split("/");
        String pageToken = null;
        if (fragments.length > 1) {
            pageToken = fragments[1];
        }
        return new ParsedRequest(fragments[0], pageToken);
    }

    private class ParsedRequest {
        private final String applicationToken;
        private final String pageToken;

        public ParsedRequest(String applicationToken, String pageToken) {
            this.applicationToken = applicationToken;
            this.pageToken = pageToken;
        }

        public String getApplicationName() {
            return this.applicationToken;
        }

        public String getPageToken() {
            return this.pageToken;
        }
    }
}

