/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.livingapps.menu;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.business.application.ApplicationMenu;
import org.bonitasoft.engine.business.application.ApplicationPageNotFoundException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.livingapps.menu.ChildrenMenuCollector;
import org.bonitasoft.livingapps.menu.Menu;
import org.bonitasoft.livingapps.menu.MenuContainer;
import org.bonitasoft.livingapps.menu.MenuLink;
import org.bonitasoft.livingapps.menu.RootMenuCollector;

public class MenuFactory {
    private final ApplicationAPI applicationApi;

    public MenuFactory(ApplicationAPI applicationApi) {
        this.applicationApi = applicationApi;
    }

    public List<Menu> create(List<ApplicationMenu> menuList) throws ApplicationPageNotFoundException, SearchException {
        return this.collect(menuList, new RootMenuCollector());
    }

    private Menu create(ApplicationMenu menu, List<ApplicationMenu> menuList) throws ApplicationPageNotFoundException, SearchException {
        if (menu.getApplicationPageId() == null) {
            return new MenuContainer(menu, this.collect(menuList, new ChildrenMenuCollector(menu.getId())));
        }
        return new MenuLink(menu, this.applicationApi.getApplicationPage(menu.getApplicationPageId().longValue()).getToken());
    }

    private List<Menu> collect(List<ApplicationMenu> items, Collector collector) throws ApplicationPageNotFoundException, SearchException {
        ArrayList<Menu> menuList = new ArrayList<Menu>();
        for (ApplicationMenu item : items) {
            if (!collector.isCollectible(item)) continue;
            menuList.add(this.create(item, items));
        }
        return menuList;
    }

    public static interface Collector {
        public boolean isCollectible(ApplicationMenu var1);
    }
}

