/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.model.bpm.flownode;

import org.bonitasoft.web.rest.model.bpm.flownode.FlowNodeItem;
import org.bonitasoft.web.rest.model.bpm.flownode.IFlowNodeItem;
import org.bonitasoft.web.rest.model.identity.UserDefinition;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ItemAttribute;
import org.bonitasoft.web.toolkit.client.data.item.attribute.modifier.ReplaceRegexpModifier;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.EnumValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.StringRegexpValidator;

public class FlowNodeDefinition
extends ItemDefinition {
    public static final String TOKEN = "flownode";
    public static final String API_URL = "../API/bpm/flowNode";
    private static final String ATTRIBUTE_NAME_FORBIDDEN_CHARACTERS = ":/\\?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=";

    @Override
    protected String defineToken() {
        return TOKEN;
    }

    @Override
    protected String defineAPIUrl() {
        return API_URL;
    }

    @Override
    protected void defineAttributes() {
        this.createAttribute("id", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("name", ItemAttribute.TYPE.STRING).isMandatory().addValidator(new StringRegexpValidator(ATTRIBUTE_NAME_FORBIDDEN_CHARACTERS, true)).addInputModifier(new ReplaceRegexpModifier(ATTRIBUTE_NAME_FORBIDDEN_CHARACTERS, "_"));
        this.createAttribute("displayName", ItemAttribute.TYPE.STRING);
        this.createAttribute("description", ItemAttribute.TYPE.TEXT);
        this.createAttribute("displayDescription", ItemAttribute.TYPE.TEXT);
        this.createAttribute("state", ItemAttribute.TYPE.ENUM).setDefaultValue("ready").addValidator(new EnumValidator("ready", "completed", "failed", "replay", "skipped"));
        this.createAttribute("caseId", ItemAttribute.TYPE.ITEM_ID).isMandatory();
        this.createAttribute("rootContainerId", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("processId", ItemAttribute.TYPE.ITEM_ID).isMandatory();
        this.createAttribute("type", ItemAttribute.TYPE.ENUM).addValidator(new EnumValidator("USER_TASK", "AUTOMATIC_TASK", "MANUAL_TASK", "BOUNDARY_EVENT", "CALL_ACTIVITY", "END_EVENT", "GATEWAY", "INTERMEDIATE_CATCH_EVENT", "", "LOOP_ACTIVITY", "EVENT"));
        this.createAttribute("executedBy", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("executedBySubstitute", ItemAttribute.TYPE.ITEM_ID);
    }

    @Override
    protected void defineDeploys() {
        super.defineDeploys();
        this.declareDeployable("processId", Definitions.get("process"));
        this.declareDeployable("caseId", Definitions.get("cases"));
        this.declareDeployable("rootContainerId", Definitions.get("process"));
        this.declareDeployable("executedBy", UserDefinition.get());
        this.declareDeployable("executedBySubstitute", UserDefinition.get());
    }

    @Override
    protected void definePrimaryKeys() {
        this.setPrimaryKeys("id");
    }

    protected IFlowNodeItem _createItem() {
        return new FlowNodeItem();
    }

    public static FlowNodeDefinition get() {
        return (FlowNodeDefinition)Definitions.get(TOKEN);
    }
}

