/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.model.bpm.flownode;

import org.bonitasoft.web.rest.model.bpm.flownode.HumanTaskItem;
import org.bonitasoft.web.rest.model.bpm.flownode.IHumanTaskItem;
import org.bonitasoft.web.rest.model.bpm.flownode.TaskDefinition;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ItemAttribute;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.EnumValidator;

public class HumanTaskDefinition
extends TaskDefinition {
    public static final String TOKEN = "humantask";
    private static final String API_URL = "../API/bpm/humanTask";

    @Override
    public String defineToken() {
        return TOKEN;
    }

    @Override
    protected String defineAPIUrl() {
        return API_URL;
    }

    @Override
    protected void defineAttributes() {
        super.defineAttributes();
        this.getAttribute("type").removeValidator(EnumValidator.class.getName()).addValidator(new EnumValidator("USER_TASK", "MANUAL_TASK"));
        this.createAttribute("actorId", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("assigned_id", ItemAttribute.TYPE.ITEM_ID);
        this.createAttribute("assigned_date", ItemAttribute.TYPE.DATETIME);
        this.createAttribute("priority", ItemAttribute.TYPE.ENUM).setDefaultValue("normal").addValidator(new EnumValidator("lowest", "under_normal", "normal", "above_normal", "highest"));
        this.createAttribute("dueDate", ItemAttribute.TYPE.DATETIME);
    }

    @Override
    protected void defineDeploys() {
        super.defineDeploys();
        this.declareDeployable("assigned_id", Definitions.get("user"));
        this.declareDeployable("actorId", Definitions.get("actor"));
    }

    @Override
    public IHumanTaskItem _createItem() {
        return new HumanTaskItem();
    }

    public static HumanTaskDefinition get() {
        return (HumanTaskDefinition)Definitions.get(TOKEN);
    }
}

