/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.model.identity;

import java.util.Date;
import org.bonitasoft.web.rest.model.identity.PersonalContactDataItem;
import org.bonitasoft.web.rest.model.identity.ProfessionalContactDataItem;
import org.bonitasoft.web.rest.model.identity.UserDefinition;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.Item;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasCreator;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasIcon;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasLastUpdateDate;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasUniqueId;

public class UserItem
extends Item
implements ItemHasUniqueId,
ItemHasLastUpdateDate,
ItemHasCreator,
ItemHasIcon {
    public static final String DEFAULT_USER_ICON = "icons/default/icon_user.png";
    public static final String ATTRIBUTE_FIRSTNAME = "firstname";
    public static final String ATTRIBUTE_LASTNAME = "lastname";
    public static final String ATTRIBUTE_PASSWORD = "password";
    public static final String ATTRIBUTE_USERNAME = "userName";
    public static final String ATTRIBUTE_MANAGER_ID = "manager_id";
    public static final String ATTRIBUTE_LAST_CONNECTION_DATE = "last_connection";
    public static final String ATTRIBUTE_TITLE = "title";
    public static final String ATTRIBUTE_JOB_TITLE = "job_title";
    public static final String ATTRIBUTE_STATE = "user_state";
    public static final String ATTRIBUTE_ENABLED = "enabled";
    public static final String VALUE_ACTIVATION_STATE_DISABLED = "DISABLED";
    public static final String VALUE_ACTIVATION_STATE_ENABLED = "ENABLED";
    public static final String FILTER_ROLE_ID = "role_id";
    public static final String FILTER_GROUP_ID = "group_id";
    public static final String FILTER_PROFILE_ID = "profile_id";
    public static final String FILTER_INDIRECT_PROFILE_ID = "indirect_profile_id";
    public static final String FILTER_PROCESS_ID = "process_id";
    public static final String FILTER_HUMAN_TASK_ID = "task_id";
    public static final String COUNTER_OPEN_TASKS = "open_tasks";
    public static final String COUNTER_OVERDUE_TASKS = "overdue_tasks";
    public static final String DEPLOY_PROFESSIONAL_DATA = "professional_data";
    public static final String DEPLOY_PERSONAL_DATA = "personnal_data";

    public UserItem() {
    }

    public UserItem(IItem item) {
        super(item);
    }

    public String getFirstName() {
        return this.getAttributeValue(ATTRIBUTE_FIRSTNAME);
    }

    public String getLastName() {
        return this.getAttributeValue(ATTRIBUTE_LASTNAME);
    }

    public String getPassword() {
        return this.getAttributeValue(ATTRIBUTE_PASSWORD);
    }

    public String getUserName() {
        return this.getAttributeValue(ATTRIBUTE_USERNAME);
    }

    public APIID getManagerId() {
        return APIID.makeAPIID(this.getAttributeValue(ATTRIBUTE_MANAGER_ID));
    }

    @Override
    public String getIcon() {
        return this.getAttributeValue("icon");
    }

    @Override
    public Date getCreationDate() {
        return this.getAttributeValueAsDate("creation_date");
    }

    @Override
    public APIID getCreatedByUserId() {
        return APIID.makeAPIID(this.getAttributeValue("created_by_user_id"));
    }

    @Override
    public Date getLastUpdateDate() {
        return this.getAttributeValueAsDate("last_update_date");
    }

    public String getState() {
        return this.getAttributeValue(ATTRIBUTE_STATE);
    }

    public String getLastConnectionDate() {
        return this.getAttributeValue(ATTRIBUTE_LAST_CONNECTION_DATE);
    }

    public String getTitle() {
        return this.getAttributeValue(ATTRIBUTE_TITLE);
    }

    public String getJobTitle() {
        return this.getAttributeValue(ATTRIBUTE_JOB_TITLE);
    }

    public boolean isEnabled() {
        return "true".equals(this.getAttributeValue(ATTRIBUTE_ENABLED));
    }

    public void setEnabled(boolean enabled) {
        this.setAttribute(ATTRIBUTE_ENABLED, String.valueOf(enabled));
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    @Override
    public void setId(Long id) {
        this.setAttribute("id", id.toString());
    }

    public void setFirstName(String firstName) {
        this.setAttribute(ATTRIBUTE_FIRSTNAME, firstName);
    }

    public void setLastName(String lastName) {
        this.setAttribute(ATTRIBUTE_LASTNAME, lastName);
    }

    public void setPassword(String password) {
        this.setAttribute(ATTRIBUTE_PASSWORD, password);
    }

    public void setUserName(String userName) {
        this.setAttribute(ATTRIBUTE_USERNAME, userName);
    }

    public void setManagerId(String id) {
        this.setAttribute(ATTRIBUTE_MANAGER_ID, id);
    }

    public void setManagerId(Long id) {
        this.setManagerId(id.toString());
    }

    public void setManagerId(APIID id) {
        this.setAttribute(ATTRIBUTE_MANAGER_ID, id);
    }

    public void setState(String state) {
        this.setAttribute(ATTRIBUTE_STATE, state);
    }

    @Override
    public void setIcon(String iconPath) {
        this.setAttribute("icon", iconPath);
    }

    @Override
    public void setCreationDate(String date) {
        this.setAttribute("creation_date", date);
    }

    @Override
    public void setCreationDate(Date date) {
        this.setAttribute("creation_date", date);
    }

    @Override
    public void setCreatedByUserId(String id) {
        this.setAttribute("created_by_user_id", id);
    }

    @Override
    public void setCreatedByUserId(Long id) {
        this.setCreatedByUserId(id.toString());
    }

    @Override
    public void setCreatedByUserId(APIID id) {
        this.setAttribute("created_by_user_id", id);
    }

    @Override
    public void setLastUpdateDate(String date) {
        this.setAttribute("last_update_date", date);
    }

    @Override
    public void setLastUpdateDate(Date date) {
        this.setAttribute("last_update_date", date);
    }

    public void setLastConnectionDate(String date) {
        this.setAttribute(ATTRIBUTE_LAST_CONNECTION_DATE, date);
    }

    public void setLastConnectionDate(Date date) {
        this.setAttribute(ATTRIBUTE_LAST_CONNECTION_DATE, date);
    }

    public void setTitle(String title) {
        this.setAttribute(ATTRIBUTE_TITLE, title);
    }

    public void setJobTitle(String jobTitle) {
        this.setAttribute(ATTRIBUTE_JOB_TITLE, jobTitle);
    }

    public ProfessionalContactDataItem getProfessionalData() {
        return new ProfessionalContactDataItem(this.getDeploy(DEPLOY_PROFESSIONAL_DATA));
    }

    public PersonalContactDataItem getPersonalData() {
        return new PersonalContactDataItem(this.getDeploy(DEPLOY_PERSONAL_DATA));
    }

    public UserItem getManager() {
        return new UserItem(this.getDeploy(ATTRIBUTE_MANAGER_ID));
    }

    @Override
    public UserItem getCreatedByUser() {
        return new UserItem(this.getDeploy("created_by_user_id"));
    }

    public ItemDefinition<UserItem> getItemDefinition() {
        return new UserDefinition();
    }
}

