/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bdm;

import org.bonitasoft.engine.api.BusinessDataAPI;
import org.bonitasoft.engine.bpm.data.DataNotFoundException;
import org.bonitasoft.engine.business.data.BusinessDataReference;
import org.bonitasoft.engine.business.data.MultipleBusinessDataReference;
import org.bonitasoft.engine.business.data.SimpleBusinessDataReference;
import org.bonitasoft.web.rest.server.api.bdm.BusinessDataReferenceClient;
import org.bonitasoft.web.rest.server.api.bdm.MultipleBusinessDataReferenceClient;
import org.bonitasoft.web.rest.server.api.bdm.SimpleBusinessDataReferenceClient;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class BusinessDataReferenceResource
extends CommonResource {
    private final BusinessDataAPI bdmAPI;

    public BusinessDataReferenceResource(BusinessDataAPI bdmAPI) {
        this.bdmAPI = bdmAPI;
    }

    @Get(value="json")
    public BusinessDataReferenceClient getProcessBusinessDataReference() throws DataNotFoundException {
        String businessDataName = this.getPathParam("dataName");
        Long processInstanceId = this.getPathParamAsLong("caseId");
        return BusinessDataReferenceResource.toClient(this.bdmAPI.getProcessBusinessDataReference(businessDataName, processInstanceId.longValue()));
    }

    public static BusinessDataReferenceClient toClient(BusinessDataReference object) {
        if (object instanceof SimpleBusinessDataReference) {
            SimpleBusinessDataReference businessDataReference = (SimpleBusinessDataReference)object;
            return new SimpleBusinessDataReferenceClient(object.getName(), object.getType(), BusinessDataReferenceResource.getUrl(object.getType(), BusinessDataReferenceResource.getStorageIdString(businessDataReference)), businessDataReference.getStorageId());
        }
        MultipleBusinessDataReference businessDataReference = (MultipleBusinessDataReference)object;
        return new MultipleBusinessDataReferenceClient(object.getName(), object.getType(), BusinessDataReferenceResource.getUrl(businessDataReference.getType(), BusinessDataReferenceResource.getValue(businessDataReference)), businessDataReference.getStorageIds());
    }

    private static String getStorageIdString(SimpleBusinessDataReference businessDataReference) {
        Long storageId = businessDataReference.getStorageId();
        if (storageId != null) {
            return storageId.toString();
        }
        return "";
    }

    static String getValue(MultipleBusinessDataReference multipleBusinessDataReference) {
        return "findByIds?ids=" + multipleBusinessDataReference.getStorageIds().toString().replaceAll("[\\[\\] ]", "");
    }

    private static String getUrl(String type, String value) {
        return "API/bdm/businessData/" + type + "/" + value;
    }

    @Override
    protected void doCatch(Throwable throwable) {
        super.doCatch(throwable);
        if (throwable.getCause() instanceof DataNotFoundException) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }
}

