/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bdm;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.BusinessDataAPI;
import org.bonitasoft.engine.business.data.BusinessDataReference;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.restlet.resource.Get;

public class BusinessDataReferencesResource
extends CommonResource {
    private final BusinessDataAPI bdmAPI;

    public BusinessDataReferencesResource(BusinessDataAPI bdmAPI) {
        this.bdmAPI = bdmAPI;
    }

    @Get(value="json")
    public List<BusinessDataReference> getProcessBusinessDataReferences() {
        Long processInstanceId = this.getCaseId();
        Integer p = this.getSearchPageNumber();
        Integer c = this.getSearchPageSize();
        return this.bdmAPI.getProcessBusinessDataReferences(processInstanceId.longValue(), p * c, c.intValue());
    }

    private Long getCaseId() {
        String[] values = this.getQuery().getValuesArray("f");
        Map<String, String> filters = this.parseFilters(Arrays.asList(values));
        String caseId = filters.get("caseId");
        if (caseId == null) {
            throw new IllegalArgumentException("filter caseId is mandatory");
        }
        try {
            return Long.parseLong(caseId);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("filter caseId should be a number");
        }
    }
}

