/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bdm;

import java.util.HashMap;
import org.bonitasoft.engine.api.CommandAPI;
import org.bonitasoft.engine.bpm.data.DataNotFoundException;
import org.bonitasoft.engine.command.CommandExecutionException;
import org.bonitasoft.engine.command.CommandNotFoundException;
import org.bonitasoft.engine.command.CommandParameterizationException;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class BusinessDataResource
extends CommonResource {
    private final CommandAPI commandAPI;

    public BusinessDataResource(CommandAPI commandAPI) {
        this.commandAPI = commandAPI;
    }

    @Get(value="json")
    public String getBusinessData() throws CommandNotFoundException, CommandExecutionException, CommandParameterizationException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("entityClassName", this.getPathParam("className"));
        parameters.put("businessDataId", this.getPathParamAsLong("id"));
        parameters.put("businessDataURIPattern", "/API/bdm/businessData/{className}/{id}/{field}");
        String child = this.getPathParam("fieldName");
        if (child != null) {
            parameters.put("businessDataChildName", child);
        }
        return (String)((Object)this.commandAPI.execute("getBusinessDataById", parameters));
    }

    @Override
    protected void doCatch(Throwable throwable) {
        DataNotFoundException dataNotFoundException = this.searchInCauseDataNotFoundException(throwable);
        if (dataNotFoundException != null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, dataNotFoundException.getMessage());
        } else {
            super.doCatch(throwable);
        }
    }

    private DataNotFoundException searchInCauseDataNotFoundException(Throwable throwable) {
        CommandExecutionException e;
        Throwable realException;
        if (throwable.getCause() != null && (realException = throwable.getCause()) instanceof CommandExecutionException && (e = (CommandExecutionException)realException).getCause() instanceof DataNotFoundException) {
            return (DataNotFoundException)e.getCause();
        }
        return null;
    }
}

