/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.cases;

import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.model.bpm.cases.CaseVariableDefinition;
import org.bonitasoft.web.rest.model.bpm.cases.CaseVariableItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.bpm.cases.APICaseVariableAttributeChecker;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseVariableDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APICaseVariable
extends ConsoleAPI<CaseVariableItem>
implements APIHasSearch<CaseVariableItem>,
APIHasUpdate<CaseVariableItem>,
APIHasGet<CaseVariableItem> {
    private APICaseVariableAttributeChecker attributeChecker = new APICaseVariableAttributeChecker();

    @Override
    public CaseVariableItem runUpdate(APIID id, Map<String, String> attributes) {
        this.attributeChecker.checkUpdateAttributes(attributes);
        id.setItemDefinition(CaseVariableDefinition.get());
        CaseVariableItem item = CaseVariableItem.fromIdAndAttributes(id, attributes);
        ((CaseVariableDatastore)this.getDefaultDatastore()).updateVariableValue(item.getCaseId(), item.getName(), item.getType(), item.getValue());
        return item;
    }

    @Override
    public ItemSearchResult<CaseVariableItem> runSearch(int page, int resultsByPage, String search, String orders, Map<String, String> filters, List<String> deploys, List<String> counters) {
        this.attributeChecker.checkSearchFilters(filters);
        long caseId = Long.valueOf(filters.get("case_id"));
        return ((CaseVariableDatastore)this.getDefaultDatastore()).findByCaseId(caseId, page, resultsByPage);
    }

    @Override
    public CaseVariableItem runGet(APIID id, List<String> deploys, List<String> counters) {
        id.setItemDefinition(CaseVariableDefinition.get());
        long caseId = id.getPartAsLong("case_id");
        String variableName = id.getPart("name");
        return ((CaseVariableDatastore)this.getDefaultDatastore()).findById(caseId, variableName);
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new CaseVariableDatastore(this.getEngineSession());
    }

    @Override
    protected ItemDefinition defineItemDefinition() {
        return CaseVariableDefinition.get();
    }

    public void setAttributeChecker(APICaseVariableAttributeChecker attributeChecker) {
        this.attributeChecker = attributeChecker;
    }
}

