/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.flownode;

import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.data.DataInstance;
import org.bonitasoft.engine.bpm.data.DataNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemIdMalformedException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMalformedUrlException;
import org.restlet.resource.Get;

public class ActivityVariableResource
extends CommonResource {
    public static final String ACTIVITYDATA_ACTIVITY_ID = "activityid";
    public static final String ACTIVITYDATA_DATA_NAME = "dataname";
    private final ProcessAPI processAPI;

    public ActivityVariableResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    @Get(value="json")
    public DataInstance getTaskVariable() {
        try {
            String taskId = this.getAttribute(ACTIVITYDATA_ACTIVITY_ID);
            String dataName = this.getAttribute(ACTIVITYDATA_DATA_NAME);
            if (taskId == null || dataName == null) {
                throw new APIMalformedUrlException("missing activity Id and or variable name");
            }
            return this.getTaskVariableInstance(dataName, this.getActivityInstanceId(taskId));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private Long getActivityInstanceId(String taskId) {
        try {
            return Long.valueOf(taskId);
        }
        catch (NumberFormatException e) {
            throw new APIItemIdMalformedException("Long", "long value expected for activity Id");
        }
    }

    private DataInstance getTaskVariableInstance(String dataName, Long activityInstanceId) throws DataNotFoundException {
        return this.processAPI.getActivityDataInstance(dataName, activityInstanceId.longValue());
    }
}

