/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.process;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.actor.ActorCriterion;
import org.bonitasoft.web.rest.model.bpm.process.ActorDefinition;
import org.bonitasoft.web.rest.model.bpm.process.ActorItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ActorDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ProcessDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.exception.APIFilterMandatoryException;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIActor
extends ConsoleAPI<ActorItem>
implements APIHasGet<ActorItem>,
APIHasSearch<ActorItem>,
APIHasUpdate<ActorItem> {
    @Override
    protected ItemDefinition defineItemDefinition() {
        return ActorDefinition.get();
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new ActorDatastore(this.getEngineSession());
    }

    @Override
    protected List<String> defineReadOnlyAttributes() {
        return Arrays.asList("process_id", "name");
    }

    @Override
    public String defineDefaultSearchOrder() {
        return ActorCriterion.NAME_ASC.name();
    }

    @Override
    public ItemSearchResult<ActorItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (MapUtil.isBlank(filters, "process_id")) {
            throw new APIFilterMandatoryException("process_id");
        }
        return super.search(page, resultsByPage, search, orders, filters);
    }

    @Override
    protected void fillDeploys(ActorItem item, List<String> deploys) {
        if (this.isDeployable("process_id", deploys, item)) {
            item.setDeploy("process_id", new ProcessDatastore(this.getEngineSession()).get(item.getProcessId()));
        }
    }

    @Override
    protected void fillCounters(ActorItem item, List<String> counters) {
        ActorDatastore actorDatastore = (ActorDatastore)this.getDefaultDatastore();
        if (counters.contains("users")) {
            item.setAttribute("users", actorDatastore.countUsers(item.getId()));
        }
        if (counters.contains("groups")) {
            item.setAttribute("groups", actorDatastore.countGroups(item.getId()));
        }
        if (counters.contains("roles")) {
            item.setAttribute("roles", actorDatastore.countRoles(item.getId()));
        }
        if (counters.contains("memberships")) {
            item.setAttribute("memberships", actorDatastore.countMemberships(item.getId()));
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public ActorItem update(APIID id, Map<String, String> attributes) {
        return (ActorItem)super.update(id, attributes);
    }
}

