/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.process;

import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.data.CharacterSet;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.resource.Get;

public class ProcessDefinitionDesignResource
extends CommonResource {
    private static final String PROCESS_DEFINITION_ID = "processDefinitionId";
    private final ProcessAPI processAPI;

    public ProcessDefinitionDesignResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    @Get(value="json")
    public String getDesign() throws ProcessDefinitionNotFoundException, IOException {
        DesignProcessDefinition design = this.processAPI.getDesignProcessDefinition(this.getProcessDefinitionIdParameter());
        JacksonRepresentation jacksonRepresentation = new JacksonRepresentation((Object)design);
        jacksonRepresentation.getObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        jacksonRepresentation.setCharacterSet(CharacterSet.UTF_8);
        return this.replaceLongIdToString(jacksonRepresentation.getText());
    }

    protected String replaceLongIdToString(String design) throws IOException {
        return design.replaceAll("([^\\\\]\"id\"\\s*:\\s*)(\\d+)", "$1\"$2\"");
    }

    protected long getProcessDefinitionIdParameter() {
        String processDefinitionId = this.getAttribute(PROCESS_DEFINITION_ID);
        if (processDefinitionId == null) {
            throw new APIException("Attribute 'processDefinitionId' is mandatory");
        }
        return Long.parseLong(processDefinitionId);
    }
}

