/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.organization;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.identity.CustomUserInfoDefinition;
import org.bonitasoft.engine.identity.CustomUserInfoDefinitionCreator;
import org.bonitasoft.web.rest.model.identity.CustomUserInfoDefinitionDefinition;
import org.bonitasoft.web.rest.model.identity.CustomUserInfoDefinitionItem;
import org.bonitasoft.web.rest.server.api.APIPreconditions;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.organization.CustomUserInfoConverter;
import org.bonitasoft.web.rest.server.engineclient.CustomUserInfoEngineClient;
import org.bonitasoft.web.rest.server.engineclient.CustomUserInfoEngineClientCreator;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APICustomUserInfoDefinition
extends ConsoleAPI<CustomUserInfoDefinitionItem>
implements APIHasAdd<CustomUserInfoDefinitionItem>,
APIHasSearch<CustomUserInfoDefinitionItem>,
APIHasDelete {
    public static final String FIX_ORDER = "Fix order";
    private final CustomUserInfoConverter converter = new CustomUserInfoConverter();
    private final CustomUserInfoEngineClientCreator engineClientCreator;

    public APICustomUserInfoDefinition(CustomUserInfoEngineClientCreator engineClientCreator) {
        this.engineClientCreator = engineClientCreator;
    }

    @Override
    public CustomUserInfoDefinitionItem add(CustomUserInfoDefinitionItem definition) {
        return this.converter.convert(this.engineClientCreator.create(this.getEngineSession()).createDefinition(new CustomUserInfoDefinitionCreator(definition.getName(), definition.getDescription())));
    }

    @Override
    public void delete(List<APIID> ids) {
        for (APIID id : ids) {
            this.engineClientCreator.create(this.getEngineSession()).deleteDefinition(id.toLong());
        }
    }

    @Override
    public ItemSearchResult<CustomUserInfoDefinitionItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        APIPreconditions.check(search == null, new T_("Search terms are not supported by this API"));
        APIPreconditions.check(filters == null || filters.isEmpty(), new T_("Filters are not supported by this API"));
        APIPreconditions.check(orders.equals(FIX_ORDER), new T_("Sorting is not supported by this API"));
        CustomUserInfoEngineClient client = this.engineClientCreator.create(this.getEngineSession());
        ArrayList<CustomUserInfoDefinitionItem> result = new ArrayList<CustomUserInfoDefinitionItem>();
        for (CustomUserInfoDefinition definition : client.listDefinitions(page * resultsByPage, resultsByPage)) {
            result.add(this.converter.convert(definition));
        }
        return new ItemSearchResult<CustomUserInfoDefinitionItem>(page, resultsByPage, client.countDefinitions(), result);
    }

    @Override
    protected ItemDefinition<CustomUserInfoDefinitionItem> defineItemDefinition() {
        return CustomUserInfoDefinitionDefinition.get();
    }

    @Override
    public String defineDefaultSearchOrder() {
        return FIX_ORDER;
    }
}

