/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.resource;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.FileNotFoundException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.bpm.contract.ContractViolationException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.TenantStatusException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.server.api.resource.ErrorMessage;
import org.bonitasoft.web.rest.server.api.resource.ErrorMessageWithExplanations;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.restlet.Request;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Range;
import org.restlet.data.Status;
import org.restlet.ext.servlet.ServletUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonResource
extends ServerResource {
    private APISession sessionSingleton = null;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CommonResource.class.getName());

    public APISession getEngineSession() {
        if (this.sessionSingleton == null) {
            HttpSession session = this.getHttpSession();
            this.sessionSingleton = (APISession)session.getAttribute("apiSession");
        }
        return this.sessionSingleton;
    }

    public HttpSession getHttpSession() {
        return this.getHttpRequest().getSession();
    }

    public HttpServletRequest getHttpRequest() {
        return ServletUtils.getRequest((Request)this.getRequest());
    }

    protected Map<String, String> getSearchFilters() {
        return this.parseFilters(this.getParameterAsList("f"));
    }

    protected String getQueryParameter(boolean mandatory) {
        return this.getParameter("q", mandatory);
    }

    protected Map<String, String> parseFilters(List<String> parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (String parameter : parameters) {
            String[] split = parameter.split("=");
            if (split.length < 2) {
                results.put(split[0], null);
                continue;
            }
            results.put(split[0], parameter.substring(split[0].length() + 1));
        }
        return results;
    }

    protected String getSearchOrder() {
        return this.getParameter("o", false);
    }

    protected String getSearchTerm() {
        return this.getParameter("s", false);
    }

    public Integer getIntegerParameter(String parameterName, boolean mandatory) {
        String parameterValue = this.getParameter(parameterName, mandatory);
        if (parameterValue != null) {
            return Integer.parseInt(parameterValue);
        }
        return null;
    }

    public Long getLongParameter(String parameterName, boolean mandatory) {
        String parameterValue = this.getParameter(parameterName, mandatory);
        if (parameterValue != null) {
            return Long.parseLong(parameterValue);
        }
        return null;
    }

    public String getParameter(String parameterName, boolean mandatory) {
        String parameter = this.getRequestParameter(parameterName);
        if (mandatory) {
            this.verifyNotNullParameter(parameter, parameterName);
        }
        return parameter;
    }

    protected String getRequestParameter(String parameterName) {
        return this.getQueryValue(parameterName);
    }

    protected void verifyNotNullParameter(Object parameter, String parameterName) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter " + parameterName + " is mandatory.");
        }
    }

    public List<String> getParameterAsList(String name) {
        return Arrays.asList(this.getQuery().getValuesArray(name));
    }

    public SearchOptions buildSearchOptions() {
        return new SearchOptionsCreator(this.getSearchPageNumber(), this.getSearchPageSize(), this.getSearchTerm(), new Sorts(this.getSearchOrder()), this.buildFilters()).create();
    }

    protected Filters buildFilters() {
        return new Filters(this.getSearchFilters());
    }

    protected void doCatch(Throwable throwable) {
        Status status;
        Throwable t = throwable.getCause() != null ? throwable.getCause() : throwable;
        ErrorMessage errorMessage = new ErrorMessage(t);
        String message = "Error while querying REST resource " + ((Object)((Object)this)).getClass().getName() + " message: " + t.getMessage();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("***" + message);
        }
        if (t instanceof IllegalArgumentException || t instanceof JsonParseException) {
            status = Status.CLIENT_ERROR_BAD_REQUEST;
        } else if (t instanceof FileNotFoundException) {
            status = Status.CLIENT_ERROR_NOT_FOUND;
            errorMessage.setMessage("File Not Found");
        } else if (t instanceof NotFoundException) {
            status = Status.CLIENT_ERROR_NOT_FOUND;
        } else if (t instanceof InvalidSessionException) {
            status = Status.CLIENT_ERROR_UNAUTHORIZED;
            SessionUtil.sessionLogout(this.getHttpSession());
        } else if (t instanceof TenantStatusException) {
            status = Status.SERVER_ERROR_SERVICE_UNAVAILABLE;
            errorMessage.setMessage("Platform is under maintenance");
        } else {
            super.doCatch(t);
            status = this.getStatus();
        }
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status, message);
            this.getResponse().setEntity(errorMessage.toEntity());
        }
    }

    protected Representation doHandle(Variant variant) throws ResourceException {
        this.setContentType(variant);
        variant.setCharacterSet(CharacterSet.UTF_8);
        return super.doHandle(variant);
    }

    protected void setContentType(Variant variant) {
        variant.setMediaType(MediaType.APPLICATION_JSON);
    }

    public String getAttribute(String name) {
        String attribute = super.getAttribute(name);
        return attribute != null ? URLDecoder.decode(attribute, StandardCharsets.UTF_8) : null;
    }

    public Long getPathParamAsLong(String parameterName) {
        String value = this.getAttribute(parameterName);
        return this.convertToLong(value);
    }

    private Long convertToLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("[ " + value + " ] must be a number");
        }
    }

    public List<Long> getParameterAsLongList(String parameterName) {
        String[] parameterValues;
        String values = this.getQuery().getValues(parameterName);
        if (values != null && (parameterValues = values.split(",")) != null && parameterValues.length > 0) {
            ArrayList<Long> longValues = new ArrayList<Long>();
            for (String parameterValue : parameterValues) {
                longValues.add(this.convertToLong(parameterValue));
            }
            return longValues;
        }
        return null;
    }

    public String getPathParam(String name) {
        return this.getAttribute(name);
    }

    protected int getSearchPageNumber() {
        try {
            return this.getIntegerParameter("p", true);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("query parameter p (page) should be a number");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("query parameter p (page) is mandatory");
        }
    }

    protected int getSearchPageSize() {
        try {
            return this.getIntegerParameter("c", true);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("query parameter c (count) should be a number");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("query parameter c (count) is mandatory");
        }
    }

    protected void setContentRange(SearchResult<?> searchResult) {
        this.setContentRange(this.getSearchPageNumber(), this.getSearchPageSize(), searchResult.getCount());
    }

    protected void setContentRange(int pageNumber, int pageSize, long count) {
        this.getResponse().getEntity().setRange(new Range((long)pageNumber, (long)(pageSize - pageNumber + 1), count, ""));
    }

    protected void manageContractViolationException(ContractViolationException e, String statusErrorMessage) {
        if (LOGGER.isInfoEnabled()) {
            StringBuilder explanations = new StringBuilder();
            for (String explanation : e.getExplanations()) {
                explanations.append(explanation);
            }
            LOGGER.info(e.getSimpleMessage() + "\nExplanations:\n" + explanations);
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, statusErrorMessage);
        ErrorMessageWithExplanations errorMessage = new ErrorMessageWithExplanations(e);
        errorMessage.setMessage(e.getSimpleMessage());
        errorMessage.setExplanations(e.getExplanations());
        this.getResponse().setEntity(errorMessage.toEntity());
    }
}

