/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.i18n.I18n;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.rest.server.api.system.Translation;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class I18nTranslationResource
extends CommonResource {
    private final I18n i18n;

    public I18nTranslationResource(I18n i18n) {
        this.i18n = i18n;
    }

    @Get(value="json")
    public List<Translation> getI18nTranslation() {
        ArrayList<Translation> items = new ArrayList<Translation>();
        String locale = this.getLocale();
        if (locale == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Request should contains 'locale' parameter.");
            return null;
        }
        Map<String, String> translations = this.i18n.getLocale(AbstractI18n.stringToLocale(locale));
        for (Map.Entry<String, String> entry : translations.entrySet()) {
            items.add(new Translation(entry.getKey(), entry.getValue()));
        }
        return items;
    }

    private String getLocale() {
        return this.getSearchFilters() != null ? this.getSearchFilters().get("locale") : null;
    }
}

