/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.applicationmenu;

import java.util.Map;
import org.bonitasoft.engine.business.application.ApplicationMenu;
import org.bonitasoft.engine.business.application.ApplicationMenuCreator;
import org.bonitasoft.engine.business.application.ApplicationMenuUpdater;
import org.bonitasoft.web.rest.model.applicationmenu.ApplicationMenuItem;

public class ApplicationMenuItemConverter {
    public ApplicationMenuItem toApplicationMenuItem(ApplicationMenu applicationMenu) {
        ApplicationMenuItem item = new ApplicationMenuItem();
        item.setId(applicationMenu.getId());
        item.setApplicationId(applicationMenu.getApplicationId());
        item.setDisplayName(applicationMenu.getDisplayName());
        if (applicationMenu.getApplicationPageId() != null) {
            item.setApplicationPageId(applicationMenu.getApplicationPageId());
        } else {
            item.setApplicationPageId("-1");
        }
        if (applicationMenu.getParentId() != null) {
            item.setParentMenuId(applicationMenu.getParentId());
        } else {
            item.setParentMenuId("-1");
        }
        item.setMenuIndex(applicationMenu.getIndex());
        return item;
    }

    public ApplicationMenuCreator toApplicationMenuCreator(ApplicationMenuItem item) {
        Long applicationId = null;
        if (item.getApplicationId() != null && item.getApplicationId().isValidLongID()) {
            applicationId = item.getApplicationId().toLong();
        }
        Long applicationPageId = null;
        if (item.getApplicationPageId() != null && item.getApplicationPageId().isValidLongID()) {
            applicationPageId = item.getApplicationPageId().toLong();
        }
        ApplicationMenuCreator menuCreator = new ApplicationMenuCreator(applicationId, item.getDisplayName(), applicationPageId);
        if (item.getParentMenuId() != null && item.getParentMenuId().isValidLongID()) {
            menuCreator.setParentId(item.getParentMenuId().toLong().longValue());
        }
        return menuCreator;
    }

    public ApplicationMenuUpdater toApplicationMenuUpdater(Map<String, String> attributes) {
        ApplicationMenuUpdater applicationMenuUpdater = new ApplicationMenuUpdater();
        if (attributes.containsKey("applicationPageId")) {
            Long appPageId = Long.parseLong(attributes.get("applicationPageId"));
            if (appPageId == -1L) {
                appPageId = null;
            }
            applicationMenuUpdater.setApplicationPageId(appPageId);
        }
        if (attributes.containsKey("displayName")) {
            applicationMenuUpdater.setDisplayName(attributes.get("displayName"));
        }
        if (attributes.containsKey("menuIndex")) {
            applicationMenuUpdater.setIndex(Integer.parseInt(attributes.get("menuIndex")));
        }
        if (attributes.containsKey("parentMenuId")) {
            Long parentMenuId = Long.parseLong(attributes.get("parentMenuId"));
            if (parentMenuId == -1L) {
                parentMenuId = null;
            }
            applicationMenuUpdater.setParentId(parentMenuId);
        }
        return applicationMenuUpdater;
    }
}

