/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.cases;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.ArchivedDocument;
import org.bonitasoft.engine.bpm.document.DocumentException;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstanceNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.identity.UserNotFoundException;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.cases.ArchivedCaseDocumentItem;
import org.bonitasoft.web.rest.model.bpm.cases.CaseDocumentItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.ArchivedCaseDocumentFilterCreator;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.ArchivedCaseDocumentItemConverter;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.ArchivedCaseDocumentSearchAttributeConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ArchivedCaseDocumentDatastore
extends CommonDatastore<ArchivedCaseDocumentItem, ArchivedDocument>
implements DatastoreHasGet<CaseDocumentItem>,
DatastoreHasDelete {
    protected final ProcessAPI processAPI;
    protected SearchOptionsCreator searchOptionsCreator;

    public ArchivedCaseDocumentDatastore(APISession engineSession, ProcessAPI processAPI) {
        super(engineSession);
        this.processAPI = processAPI;
    }

    @Override
    public ArchivedCaseDocumentItem get(APIID id) {
        try {
            ArchivedDocument documentItem = this.processAPI.getArchivedProcessDocument(id.toLong().longValue());
            return this.convertEngineToConsoleItem(documentItem);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public ItemSearchResult<ArchivedCaseDocumentItem> search(int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        return this.searchDocument(page, resultsByPage, search, filters, orders);
    }

    protected ItemSearchResult<ArchivedCaseDocumentItem> searchDocument(int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        try {
            APIID supervisorAPIID = APIID.makeAPIID(filters.get("supervisor_id"));
            APIID archivedCaseId = APIID.makeAPIID(filters.get("archivedCaseId"));
            if (supervisorAPIID != null) {
                filters.remove("supervisor_id");
            }
            if (archivedCaseId != null && archivedCaseId.isValidLongID()) {
                filters.remove("archivedCaseId");
                ArchivedProcessInstance archivedProcessInstance = this.processAPI.getArchivedProcessInstance(archivedCaseId.toLong().longValue());
                if (archivedProcessInstance != null) {
                    Long sourceCaseId = archivedProcessInstance.getSourceObjectId();
                    filters.put("caseId", sourceCaseId.toString());
                }
            }
            this.searchOptionsCreator = this.buildSearchOptionCreator(page, resultsByPage, search, filters, orders);
            SearchResult engineSearchResults = supervisorAPIID != null && supervisorAPIID.isValidLongID() ? this.processAPI.searchArchivedDocumentsSupervisedBy(supervisorAPIID.toLong().longValue(), this.searchOptionsCreator.create()) : this.processAPI.searchArchivedDocuments(this.searchOptionsCreator.create());
            return new ItemSearchResult<ArchivedCaseDocumentItem>(page, resultsByPage, engineSearchResults.getCount(), this.convertEngineToConsoleItem(engineSearchResults.getResult()));
        }
        catch (ArchivedProcessInstanceNotFoundException e) {
            throw new APIException("archivedCaseId not found. Request with bad param value.");
        }
        catch (UserNotFoundException e) {
            throw new APIException("supervisor_id not found. Request with bad param value.");
        }
        catch (SearchException e) {
            throw new APIException("Error while searching.");
        }
    }

    protected SearchOptionsCreator buildSearchOptionCreator(int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, this.getArchivedDocumentSearchAttributeConverter()), new Filters(filters, new ArchivedCaseDocumentFilterCreator(this.getArchivedDocumentSearchAttributeConverter())));
    }

    private ArchivedCaseDocumentSearchAttributeConverter getArchivedDocumentSearchAttributeConverter() {
        return new ArchivedCaseDocumentSearchAttributeConverter();
    }

    @Override
    public void delete(List<APIID> ids) {
        if (ids != null) {
            try {
                for (APIID id : ids) {
                    this.processAPI.deleteContentOfArchivedDocument(id.toLong().longValue());
                }
            }
            catch (DocumentNotFoundException e) {
                throw new APIException("Error while deleting a document. Document not found");
            }
            catch (DocumentException e) {
                throw new APIException(e);
            }
        } else {
            throw new APIException("Error while deleting a document. Document id not specified in the request");
        }
    }

    @Override
    protected ArchivedCaseDocumentItem convertEngineToConsoleItem(ArchivedDocument item) {
        if (item != null) {
            return new ArchivedCaseDocumentItemConverter().convert(item);
        }
        return null;
    }

    @Override
    private List<ArchivedCaseDocumentItem> convertEngineToConsoleItem(List<ArchivedDocument> result) {
        if (result != null) {
            return new ArchivedCaseDocumentItemConverter().convert(result);
        }
        return null;
    }
}

