/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.cases;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.web.rest.model.bpm.cases.CaseItem;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseItemConverter;
import org.bonitasoft.web.rest.server.datastore.utils.VariableMapper;
import org.bonitasoft.web.rest.server.datastore.utils.VariablesMapper;
import org.bonitasoft.web.rest.server.engineclient.CaseEngineClient;
import org.bonitasoft.web.rest.server.engineclient.ProcessEngineClient;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class CaseSarter {
    private final CaseItem caseItem;
    private final CaseEngineClient caseEngineClient;
    private final ProcessEngineClient processEngineClient;
    private final Long processId;
    private final Long delegateUserId;

    public CaseSarter(CaseItem caseItem, CaseEngineClient caseEngineClient, ProcessEngineClient processEngineClient) {
        APIID startedBySubstituteUserId;
        this.caseItem = caseItem;
        this.processId = caseItem.getProcessId().toLong();
        this.delegateUserId = caseItem.hasAttribute("startedBySubstitute") && caseItem.getStartedBySubstituteUserId() != null ? ((startedBySubstituteUserId = caseItem.getStartedBySubstituteUserId()).isValidLongID() ? startedBySubstituteUserId.toLong() : Long.valueOf(-1L)) : Long.valueOf(-1L);
        this.caseEngineClient = caseEngineClient;
        this.processEngineClient = processEngineClient;
    }

    public CaseItem start() {
        HashMap<String, Serializable> variables = this.getVariables(this.caseItem);
        if (variables.isEmpty()) {
            return this.startCase();
        }
        return this.startCaseWithVariables(variables);
    }

    private HashMap<String, Serializable> getVariables(CaseItem caseItem) {
        String jsonVariables = caseItem.getAttributeValue("variables");
        if (StringUtil.isBlank(jsonVariables)) {
            return new HashMap<String, Serializable>();
        }
        return this.buildVariablesMap(jsonVariables);
    }

    private HashMap<String, Serializable> buildVariablesMap(String jsonValue) {
        List<DataDefinition> dataDefinitions = this.processEngineClient.getProcessDataDefinitions(this.processId);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (VariableMapper var : VariablesMapper.fromJson(jsonValue).getVariables()) {
            DataDefinition data = this.getDataDefinitionByName(var.getName(), dataDefinitions);
            map.put(var.getName(), var.getSerializableValue(data.getClassName()));
        }
        return map;
    }

    private CaseItem startCaseWithVariables(HashMap<String, Serializable> variables) {
        ProcessInstance processInstance = this.caseEngineClient.start(this.delegateUserId, this.processId, variables);
        return new CaseItemConverter().convert(processInstance);
    }

    private CaseItem startCase() {
        ProcessInstance processInstance = this.caseEngineClient.start(this.delegateUserId, this.processId);
        return new CaseItemConverter().convert(processInstance);
    }

    private DataDefinition getDataDefinitionByName(String dataName, List<DataDefinition> dataDefinitions) {
        for (DataDefinition dataDefinition : dataDefinitions) {
            if (!dataDefinition.getName().equals(dataName)) continue;
            return dataDefinition;
        }
        throw new APIException(new T_("Data definition %dataName% doesn't exists for process %processId%", new Arg("dataName", dataName), new Arg("processId", this.caseItem.getProcessId())));
    }
}

