/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.connector.ArchivedConnectorInstance;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.connector.ArchivedConnectorInstanceItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.connector.ArchivedConnectorInstanceItemWrapper;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;

public class ArchivedConnectorInstanceDatastore
extends CommonDatastore<ArchivedConnectorInstanceItem, ArchivedConnectorInstance>
implements DatastoreHasSearch<ArchivedConnectorInstanceItem> {
    public ArchivedConnectorInstanceDatastore(APISession engineSession) {
        super(engineSession);
    }

    protected ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<ArchivedConnectorInstanceItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchResult searchConnectorInstances;
        try {
            searchConnectorInstances = this.getProcessAPI().searchArchivedConnectorInstances(this.buildSearchOptions(page, resultsByPage, search, orders, filters));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
        if (searchConnectorInstances != null) {
            List<ArchivedConnectorInstanceItem> convertedResult = this.convertEngineItemsIntoConsoleItems(searchConnectorInstances.getResult());
            return new ItemSearchResult<ArchivedConnectorInstanceItem>(page, convertedResult.size(), searchConnectorInstances.getCount(), convertedResult);
        }
        throw new APIException("Search failed for the following parameters <page: " + page + " - resulsByPage: " + resultsByPage + " - search: " + search + " - filters: " + filters + " - orders: " + orders + ">");
    }

    protected SearchOptions buildSearchOptions(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
        this.addStringFilterToSearchBuilder(filters, builder, "containerId", "containerId");
        this.addStringFilterToSearchBuilder(filters, builder, "state", "state");
        return builder.done();
    }

    @Override
    protected ArchivedConnectorInstanceItem convertEngineToConsoleItem(ArchivedConnectorInstance engineItem) {
        return new ArchivedConnectorInstanceItemWrapper(engineItem);
    }

    protected List<ArchivedConnectorInstanceItem> convertEngineItemsIntoConsoleItems(List<ArchivedConnectorInstance> engineItemList) {
        if (engineItemList != null) {
            ArrayList<ArchivedConnectorInstanceItem> consoleItemList = new ArrayList<ArchivedConnectorInstanceItem>();
            for (ArchivedConnectorInstance engineItem : engineItemList) {
                consoleItemList.add(this.convertEngineToConsoleItem(engineItem));
            }
            return consoleItemList;
        }
        throw new RuntimeException("List of engine items is null");
    }
}

