/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.connector.ConnectorInstance;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.connector.ConnectorInstanceItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.connector.ConnectorInstanceItemWrapper;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;

public class ConnectorInstanceDatastore
extends CommonDatastore<ConnectorInstanceItem, ConnectorInstance>
implements DatastoreHasSearch<ConnectorInstanceItem> {
    public ConnectorInstanceDatastore(APISession engineSession) {
        super(engineSession);
    }

    protected ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<ConnectorInstanceItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchResult searchConnectorInstances;
        try {
            searchConnectorInstances = this.getProcessAPI().searchConnectorInstances(this.buildSearchOptions(page, resultsByPage, search, orders, filters));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
        if (searchConnectorInstances != null) {
            List<ConnectorInstanceItem> convertedResult = this.convertEngineItemsIntoConsoleItems(searchConnectorInstances.getResult());
            return new ItemSearchResult<ConnectorInstanceItem>(page, resultsByPage, searchConnectorInstances.getCount(), convertedResult);
        }
        throw new APIException("Search failed for the following parameters <page: " + page + " - resulsByPage: " + resultsByPage + " - search: " + search + " - filters: " + filters + " - orders: " + orders + ">");
    }

    protected SearchOptions buildSearchOptions(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
        this.addStringFilterToSearchBuilder(filters, builder, "containerId", "containerId");
        this.addStringFilterToSearchBuilder(filters, builder, "state", "state");
        return builder.done();
    }

    @Override
    protected ConnectorInstanceItem convertEngineToConsoleItem(ConnectorInstance engineItem) {
        return new ConnectorInstanceItemWrapper(engineItem);
    }

    protected List<ConnectorInstanceItem> convertEngineItemsIntoConsoleItems(List<ConnectorInstance> engineItemList) {
        if (engineItemList != null) {
            ArrayList<ConnectorInstanceItem> consoleItemList = new ArrayList<ConnectorInstanceItem>();
            for (ConnectorInstance engineItem : engineItemList) {
                consoleItemList.add(this.convertEngineToConsoleItem(engineItem));
            }
            return consoleItemList;
        }
        throw new RuntimeException("List of engine items is null");
    }
}

