/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.actor.ActorCriterion;
import org.bonitasoft.engine.bpm.actor.ActorInstance;
import org.bonitasoft.engine.bpm.actor.ActorUpdater;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.bpm.process.ActorItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ActorDatastore
extends CommonDatastore<ActorItem, ActorInstance>
implements DatastoreHasGet<ActorItem>,
DatastoreHasSearch<ActorItem>,
DatastoreHasUpdate<ActorItem> {
    public ActorDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    protected ActorItem convertEngineToConsoleItem(ActorInstance engineItem) {
        ActorItem result = new ActorItem();
        result.setId(engineItem.getId());
        result.setName(engineItem.getName());
        result.setDisplayName(engineItem.getDisplayName());
        result.setDescription(engineItem.getDescription());
        result.setProcessId(engineItem.getProcessDefinitionId());
        return result;
    }

    private ProcessAPI getProcessAPI() throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
    }

    @Override
    public ActorItem get(APIID id) {
        try {
            return this.convertEngineToConsoleItem(this.getProcessAPI().getActor(id.toLong().longValue()));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<ActorItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            Long processId = MapUtil.getValueAsLong(filters, "process_id");
            List actors = this.getProcessAPI().getActors(processId.longValue(), SearchOptionsBuilderUtil.computeIndex(page, resultsByPage), resultsByPage, ActorCriterion.valueOf((String)orders.toUpperCase().replace(" ", "_")));
            return new ItemSearchResult<ActorItem>(page, resultsByPage, this.getProcessAPI().getNumberOfActors(processId.longValue()), this.convertEngineToConsoleItemsList(actors));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public ActorItem update(APIID id, Map<String, String> attributes) {
        try {
            ActorUpdater updater = new ActorUpdater();
            if (attributes.containsKey("displayName")) {
                updater.setDisplayName(attributes.get("displayName"));
            }
            if (attributes.containsKey("description")) {
                updater.setDescription(attributes.get("description"));
            }
            return this.convertEngineToConsoleItem(this.getProcessAPI().updateActor(id.toLong().longValue(), updater));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public Long countUsers(APIID actorId) {
        try {
            return this.getProcessAPI().getNumberOfUsersOfActor(actorId.toLong().longValue());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public Long countGroups(APIID actorId) {
        try {
            return this.getProcessAPI().getNumberOfGroupsOfActor(actorId.toLong().longValue());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public Long countRoles(APIID actorId) {
        try {
            return this.getProcessAPI().getNumberOfRolesOfActor(actorId.toLong().longValue());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public Long countMemberships(APIID actorId) {
        try {
            return this.getProcessAPI().getNumberOfMembershipsOfActor(actorId.toLong().longValue());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }
}

