/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.utils.ListUtil;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.actor.ActorMember;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.bpm.process.ActorMemberItem;
import org.bonitasoft.web.rest.model.identity.MemberType;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.exception.APIAttributesException;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ActorMemberDatastore
extends CommonDatastore<ActorMemberItem, ActorMember>
implements DatastoreHasAdd<ActorMemberItem>,
DatastoreHasSearch<ActorMemberItem>,
DatastoreHasDelete {
    public ActorMemberDatastore(APISession engineSession) {
        super(engineSession);
    }

    private ProcessAPI getProcessAPI() throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            for (APIID id : ids) {
                this.getProcessAPI().removeActorMember(id.toLong().longValue());
            }
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<ActorMemberItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            Long actorId = MapUtil.getValueAsLong(filters, "actor_id");
            List unfilteredResults = this.getProcessAPI().getActorMembers(actorId.longValue(), 0, Integer.MAX_VALUE);
            List<ActorMember> filteredResults = this.applyTypeFilter(filters.get("member_type"), unfilteredResults);
            List<?> paginatedResults = ListUtil.paginate(filteredResults, page, resultsByPage);
            List finalResults = this.convertEngineToConsoleItemsList(paginatedResults);
            for (ActorMemberItem actorMemberItem : finalResults) {
                actorMemberItem.setActorId(actorId);
            }
            return new ItemSearchResult<ActorMemberItem>(page, resultsByPage, filteredResults.size(), finalResults);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private List<ActorMember> applyTypeFilter(String filterType, List<ActorMember> unfilteredResults) {
        ArrayList<ActorMember> filteredResults = new ArrayList<ActorMember>();
        if (StringUtil.isBlank(filterType)) {
            filteredResults.addAll(unfilteredResults);
        } else if (this.isMemberTypeUser(filterType)) {
            this.filterToUser(unfilteredResults, filteredResults);
        } else if (this.isMemberTypeRole(filterType)) {
            this.filterToRole(unfilteredResults, filteredResults);
        } else if (this.isMemberTypeGroup(filterType)) {
            this.filterToGroup(unfilteredResults, filteredResults);
        } else if (this.isMemberTypeMembership(filterType)) {
            this.filterToMembership(unfilteredResults, filteredResults);
        }
        return filteredResults;
    }

    private boolean isMemberTypeUser(String filterType) {
        return "user".equalsIgnoreCase(filterType) || MemberType.USER.name().equals(filterType);
    }

    private boolean isMemberTypeRole(String filterType) {
        return "role".equalsIgnoreCase(filterType) || MemberType.ROLE.name().equals(filterType);
    }

    private boolean isMemberTypeGroup(String filterType) {
        return "group".equalsIgnoreCase(filterType) || MemberType.GROUP.name().equals(filterType);
    }

    private boolean isMemberTypeMembership(String filterType) {
        return "roleAndGroup".equalsIgnoreCase(filterType) || MemberType.MEMBERSHIP.name().equals(filterType);
    }

    private void filterToUser(List<ActorMember> unfilteredResults, List<ActorMember> filteredResults) {
        for (ActorMember result : unfilteredResults) {
            if (APIID.makeAPIID(result.getUserId()) == null) continue;
            filteredResults.add(result);
        }
    }

    private void filterToRole(List<ActorMember> unfilteredResults, List<ActorMember> filteredResults) {
        for (ActorMember result : unfilteredResults) {
            if (APIID.makeAPIID(result.getRoleId()) == null || APIID.makeAPIID(result.getGroupId()) != null) continue;
            filteredResults.add(result);
        }
    }

    private void filterToGroup(List<ActorMember> unfilteredResults, List<ActorMember> filteredResults) {
        for (ActorMember result : unfilteredResults) {
            if (APIID.makeAPIID(result.getGroupId()) == null || APIID.makeAPIID(result.getRoleId()) != null) continue;
            filteredResults.add(result);
        }
    }

    private void filterToMembership(List<ActorMember> unfilteredResults, List<ActorMember> filteredResults) {
        for (ActorMember result : unfilteredResults) {
            if (APIID.makeAPIID(result.getGroupId()) == null || APIID.makeAPIID(result.getRoleId()) == null) continue;
            filteredResults.add(result);
        }
    }

    @Override
    public ActorMemberItem add(ActorMemberItem item) {
        try {
            ActorMember addedActorMember = null;
            if (this.isUserActorMember(item)) {
                addedActorMember = this.addUserActorMember(item);
            } else if (this.isMembershipActorMember(item)) {
                addedActorMember = this.addMembershipActorMember(item);
            } else if (this.isRoleActorMember(item)) {
                addedActorMember = this.addRoleActorMember(item);
            } else if (this.isGroupActorMember(item)) {
                addedActorMember = this.addGroupActorMember(item);
            } else {
                throw new APIAttributesException("user_id", "role_id", "group_id");
            }
            ActorMemberItem addedItem = this.convertEngineToConsoleItem(addedActorMember);
            addedItem.setActorId(item.getActorId());
            return addedItem;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private ActorMember addGroupActorMember(ActorMemberItem item) throws InvalidSessionException, NotFoundException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        try {
            return this.getProcessAPI().addGroupToActor(item.getActorId().toLong().longValue(), item.getGroupId().toLong().longValue());
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("This group has already been mapped to actor"), (Throwable)e);
        }
        catch (CreationException e) {
            throw new APIException(new T_("Error when adding group to actor member"), (Throwable)e);
        }
    }

    private ActorMember addRoleActorMember(ActorMemberItem item) throws InvalidSessionException, NotFoundException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        try {
            return this.getProcessAPI().addRoleToActor(item.getActorId().toLong().longValue(), item.getRoleId().toLong().longValue());
        }
        catch (CreationException e) {
            throw new APIForbiddenException(new T_("This role has already been mapped to actor"), (Throwable)e);
        }
    }

    private ActorMember addMembershipActorMember(ActorMemberItem item) throws InvalidSessionException, NotFoundException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        try {
            return this.getProcessAPI().addRoleAndGroupToActor(item.getActorId().toLong().longValue(), item.getRoleId().toLong().longValue(), item.getGroupId().toLong().longValue());
        }
        catch (CreationException e) {
            throw new APIForbiddenException(new T_("This membership has already been mapped to actor"), (Throwable)e);
        }
    }

    private ActorMember addUserActorMember(ActorMemberItem item) throws InvalidSessionException, NotFoundException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        try {
            return this.getProcessAPI().addUserToActor(item.getActorId().toLong().longValue(), item.getUserId().toLong().longValue());
        }
        catch (CreationException e) {
            throw new APIForbiddenException(new T_("This user has already been mapped to actor"), (Throwable)e);
        }
    }

    private boolean isGroupActorMember(ActorMemberItem item) {
        return item.getGroupId() != null;
    }

    private boolean isRoleActorMember(ActorMemberItem item) {
        return item.getRoleId() != null;
    }

    private boolean isMembershipActorMember(ActorMemberItem item) {
        return this.isRoleActorMember(item) && this.isGroupActorMember(item);
    }

    private boolean isUserActorMember(ActorMemberItem item) {
        return item.getUserId() != null;
    }

    @Override
    protected ActorMemberItem convertEngineToConsoleItem(ActorMember item) {
        ActorMemberItem actorMemberItem = new ActorMemberItem();
        actorMemberItem.setId(item.getId());
        actorMemberItem.setUserId(item.getUserId());
        actorMemberItem.setRoleId(item.getRoleId());
        actorMemberItem.setGroupId(item.getGroupId());
        return actorMemberItem;
    }
}

