/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import java.util.Map;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.identity.ContactData;
import org.bonitasoft.engine.identity.ContactDataUpdater;
import org.bonitasoft.engine.identity.UserUpdater;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.identity.ProfessionalContactDataItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.ContactDataConverter;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ProfessionalContactDataDatastore
extends CommonDatastore<ProfessionalContactDataItem, ContactData>
implements DatastoreHasGet<ProfessionalContactDataItem>,
DatastoreHasUpdate<ProfessionalContactDataItem>,
DatastoreHasAdd<ProfessionalContactDataItem> {
    public ProfessionalContactDataDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    public ProfessionalContactDataItem get(APIID id) {
        try {
            ContactData result = TenantAPIAccessor.getIdentityAPI((APISession)this.getEngineSession()).getUserContactData(id.toLong().longValue(), false);
            return this.createContactDataItemConverter(id).convert(result);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ProfessionalContactDataItem update(APIID id, Map<String, String> attributes) {
        try {
            ContactDataUpdater professionalDataUpdater = new ContactDataUpdater();
            if (attributes.containsKey("email")) {
                professionalDataUpdater.setEmail(attributes.get("email"));
            }
            if (attributes.containsKey("phone_number")) {
                professionalDataUpdater.setPhoneNumber(attributes.get("phone_number"));
            }
            if (attributes.containsKey("mobile_number")) {
                professionalDataUpdater.setMobileNumber(attributes.get("mobile_number"));
            }
            if (attributes.containsKey("fax_number")) {
                professionalDataUpdater.setFaxNumber(attributes.get("fax_number"));
            }
            if (attributes.containsKey("building")) {
                professionalDataUpdater.setBuilding(attributes.get("building"));
            }
            if (attributes.containsKey("room")) {
                professionalDataUpdater.setRoom(attributes.get("room"));
            }
            if (attributes.containsKey("address")) {
                professionalDataUpdater.setAddress(attributes.get("address"));
            }
            if (attributes.containsKey("zipcode")) {
                professionalDataUpdater.setZipCode(attributes.get("zipcode"));
            }
            if (attributes.containsKey("city")) {
                professionalDataUpdater.setCity(attributes.get("city"));
            }
            if (attributes.containsKey("state")) {
                professionalDataUpdater.setState(attributes.get("state"));
            }
            if (attributes.containsKey("country")) {
                professionalDataUpdater.setCountry(attributes.get("country"));
            }
            if (attributes.containsKey("website")) {
                professionalDataUpdater.setWebsite(attributes.get("website"));
            }
            UserUpdater userUpdater = new UserUpdater().setProfessionalContactData(professionalDataUpdater).setPersonalContactData(new ContactDataUpdater());
            TenantAPIAccessor.getIdentityAPI((APISession)this.getEngineSession()).updateUser(id.toLong().longValue(), userUpdater);
            return this.get(id);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ProfessionalContactDataItem add(ProfessionalContactDataItem item) {
        return this.update(item.getId(), (Map)item.getAttributes());
    }

    @Override
    protected ProfessionalContactDataItem convertEngineToConsoleItem(ContactData item) {
        throw new RuntimeException("Use ContactDataConverter instead!");
    }

    private ContactDataConverter<ProfessionalContactDataItem> createContactDataItemConverter(final APIID id) {
        return new ContactDataConverter<ProfessionalContactDataItem>(){

            @Override
            public ProfessionalContactDataItem createContactDataItem() {
                return new ProfessionalContactDataItem();
            }

            @Override
            public void setContactId(ProfessionalContactDataItem contactData) {
                contactData.setId(id);
            }
        };
    }
}

