/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.profile.member;

import java.util.Map;
import org.bonitasoft.engine.profile.ProfileMember;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.rest.model.portal.profile.ProfileMemberItem;
import org.bonitasoft.web.rest.server.datastore.converter.ItemSearchResultConverter;
import org.bonitasoft.web.rest.server.datastore.filter.FilterAccessor;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.filter.GenericFilterCreator;
import org.bonitasoft.web.rest.server.datastore.profile.member.MemberType;
import org.bonitasoft.web.rest.server.datastore.profile.member.MemberTypeConverter;
import org.bonitasoft.web.rest.server.datastore.profile.member.ProfileMemberItemConverter;
import org.bonitasoft.web.rest.server.datastore.profile.member.ProfileMemberSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.engineclient.ProfileMemberEngineClient;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;

public class SearchProfileMembersHelper
implements DatastoreHasSearch<ProfileMemberItem> {
    private final ProfileMemberEngineClient profileMemberClient;

    public SearchProfileMembersHelper(ProfileMemberEngineClient profileMemberClient) {
        this.profileMemberClient = profileMemberClient;
    }

    @Override
    public ItemSearchResult<ProfileMemberItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator options = this.makeSearchOptions(page, resultsByPage, search, orders, filters);
        SearchResult<ProfileMember> searchResult = this.profileMemberClient.searchProfileMembers(this.getMemberType(filters).getType(), options.create());
        return new ItemSearchResultConverter<ProfileMemberItem, ProfileMember>(page, resultsByPage, searchResult, new ProfileMemberItemConverter()).toItemSearchResult();
    }

    private MemberType getMemberType(Map<String, String> filters) {
        FilterAccessor filterAccess = new FilterAccessor(filters);
        return filterAccess.getMandatory("member_type", new MemberTypeConverter());
    }

    private SearchOptionsCreator makeSearchOptions(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, new ProfileMemberSearchDescriptorConverter()), new Filters(filters, new GenericFilterCreator(new ProfileMemberSearchDescriptorConverter())));
    }
}

