/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.utils;

import java.io.Serializable;
import org.bonitasoft.web.rest.server.datastore.utils.Variable;
import org.bonitasoft.web.rest.server.framework.json.JacksonDeserializer;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;

public class VariableMapper {
    private final JacksonDeserializer deserializer;
    private final Variable variable;

    public VariableMapper(Variable variable, JacksonDeserializer jacksonDeserializer) {
        this.variable = variable;
        this.deserializer = jacksonDeserializer;
    }

    public Serializable getSerializableValue(String className) {
        try {
            return (Serializable)this.deserializer.convertValue(this.variable.getValue(), Class.forName(className));
        }
        catch (IllegalArgumentException e) {
            throw new APIException(new T_("%value% is not a valid value for %className%", new Arg("value", this.variable.getValue()), new Arg("className", className)));
        }
        catch (ClassNotFoundException e) {
            throw new APIException(new T_("%className% not found. Only jdk types are supported", new Arg("className", className)));
        }
        catch (ClassCastException e) {
            throw new APIException(new T_("%className% is not Serializable", new Arg("className", className)));
        }
    }

    public String getName() {
        return this.variable.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableMapper other = (VariableMapper)obj;
        return this.variable != null && this.variable.equals(other.variable);
    }
}

