/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import java.util.List;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.identity.UserCreator;
import org.bonitasoft.engine.identity.UserNotFoundException;
import org.bonitasoft.engine.identity.UserUpdater;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;

public class UserEngineClient {
    private final IdentityAPI identityAPI;

    public UserEngineClient(IdentityAPI identityAPI) {
        this.identityAPI = identityAPI;
    }

    public User update(long userId, UserUpdater userUpdater) {
        try {
            return this.identityAPI.updateUser(userId, userUpdater);
        }
        catch (UserNotFoundException e) {
            throw new APINotFoundException(new T_("Can't update user. User not found"), (Throwable)e);
        }
        catch (UpdateException e) {
            throw new APIException(new T_("Error when updating user"), (Throwable)e);
        }
    }

    public User create(UserCreator creator) {
        try {
            return this.identityAPI.createUser(creator);
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("Can't create user. User '%userName%' already exists", new Arg("userName", creator.getFields().get(UserCreator.UserField.NAME))), (Throwable)e);
        }
        catch (CreationException e) {
            throw new APIException(new T_("Error when creating user"), (Throwable)e);
        }
    }

    public User get(long userId) {
        try {
            return this.identityAPI.getUser(userId);
        }
        catch (UserNotFoundException e) {
            throw new APINotFoundException(new T_("User not found"), (Throwable)e);
        }
    }

    public void delete(List<Long> userIds) {
        try {
            this.identityAPI.deleteUsers(userIds);
        }
        catch (DeletionException e) {
            throw new APIException(new T_("Error when deleting users"), (Throwable)e);
        }
    }

    public SearchResult<User> search(SearchOptions searchOptions) {
        try {
            return this.identityAPI.searchUsers(searchOptions);
        }
        catch (SearchException e) {
            throw new APIException(new T_("Error when searching users"), (Throwable)e);
        }
    }
}

