/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import org.bonitasoft.engine.bdm.serialization.CustomLocalDateDeserializer;
import org.bonitasoft.engine.bdm.serialization.CustomLocalDateSerializer;
import org.bonitasoft.engine.bdm.serialization.CustomLocalDateTimeDeserializer;
import org.bonitasoft.engine.bdm.serialization.CustomLocalDateTimeSerializer;
import org.bonitasoft.engine.bdm.serialization.CustomOffsetDateTimeDeserializer;
import org.bonitasoft.engine.bdm.serialization.CustomOffsetDateTimeSerializer;
import org.bonitasoft.web.rest.server.utils.DataInstanceSerializer;
import org.bonitasoft.web.rest.server.utils.TimerEventTriggerInstanceSerializer;
import org.restlet.data.MediaType;
import org.restlet.ext.jackson.JacksonConverter;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;

public class BonitaJacksonConverter
extends JacksonConverter {
    protected <T> JacksonRepresentation<T> create(MediaType mediaType, T source) {
        ObjectMapper mapper = this.createMapper();
        JacksonRepresentation jr = new JacksonRepresentation(mediaType, source);
        jr.setObjectMapper(mapper);
        return jr;
    }

    protected <T> JacksonRepresentation<T> create(Representation source, Class<T> objectClass) {
        ObjectMapper mapper = this.createMapper();
        JacksonRepresentation jr = new JacksonRepresentation(source, objectClass);
        jr.setObjectMapper(mapper);
        return jr;
    }

    private ObjectMapper createMapper() {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new DataInstanceSerializer());
        simpleModule.addSerializer((JsonSerializer)new TimerEventTriggerInstanceSerializer());
        simpleModule.addDeserializer(LocalDate.class, (JsonDeserializer)new CustomLocalDateDeserializer());
        simpleModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new CustomLocalDateTimeDeserializer());
        simpleModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new CustomOffsetDateTimeDeserializer());
        simpleModule.addSerializer(LocalDate.class, (JsonSerializer)new CustomLocalDateSerializer());
        simpleModule.addSerializer(LocalDateTime.class, (JsonSerializer)new CustomLocalDateTimeSerializer());
        simpleModule.addSerializer(OffsetDateTime.class, (JsonSerializer)new CustomOffsetDateTimeSerializer());
        mapper.registerModule((Module)simpleModule);
        return mapper;
    }
}

