/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bonitasoft.web.toolkit.client.common.AbstractTreeNode;
import org.bonitasoft.web.toolkit.client.common.TreeLeaf;
import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;

public class Tree<VALUE_CLASS>
extends AbstractTreeNode<VALUE_CLASS>
implements Iterable<AbstractTreeNode<VALUE_CLASS>> {
    protected List<AbstractTreeNode<VALUE_CLASS>> children = new ArrayList<AbstractTreeNode<VALUE_CLASS>>();

    public void addNode(AbstractTreeNode<VALUE_CLASS> node) {
        if (node == null) {
            return;
        }
        node.setParent(this);
        this.children.add(node);
    }

    public void addValue(VALUE_CLASS value) {
        if (value != null && !this.contains(value)) {
            this.addNode(new TreeLeaf<VALUE_CLASS>(this, value));
        }
    }

    public List<VALUE_CLASS> getValues() {
        ArrayList values = new ArrayList();
        for (AbstractTreeNode<VALUE_CLASS> node : this.children) {
            if (!(node instanceof TreeLeaf)) continue;
            values.add(((TreeLeaf)node).getValue());
        }
        return values;
    }

    public AbstractTreeNode<VALUE_CLASS> get(int index) {
        return this.children.get(index);
    }

    public String toString() {
        return this.children.toString();
    }

    public int size() {
        return this.children.size();
    }

    public boolean contains(VALUE_CLASS value) {
        return this.getValues().contains(value);
    }

    @Override
    public Iterator<AbstractTreeNode<VALUE_CLASS>> iterator() {
        return this.children.iterator();
    }

    @Override
    public String toJson() {
        return JSonSerializer.serializeCollection(this.children);
    }

    @Override
    public Tree<VALUE_CLASS> copy() {
        Tree<VALUE_CLASS> result = new Tree<VALUE_CLASS>();
        for (AbstractTreeNode<VALUE_CLASS> child : this.children) {
            result.addNode(child.copy());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tree)) {
            return false;
        }
        Tree tree = (Tree)o;
        if (tree.size() != this.size()) {
            return false;
        }
        for (VALUE_CLASS valueThis : this.getValues()) {
            for (VALUE_CLASS valueOther : tree.getValues()) {
                if (valueThis.equals(valueOther)) continue;
                return false;
            }
        }
        for (VALUE_CLASS valueOther : tree.getValues()) {
            for (VALUE_CLASS valueThis : this.getValues()) {
                if (valueThis.equals(valueOther)) continue;
                return false;
            }
        }
        return true;
    }

    public List<AbstractTreeNode<VALUE_CLASS>> getNodes() {
        return this.children;
    }
}

