/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item.attribute;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.toolkit.client.common.TreeIndexed;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidationError;
import org.bonitasoft.web.toolkit.client.data.item.attribute.ValidationException;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.AbstractStringValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.MandatoryValidator;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.Validator;

public class ValidatorEngine {
    public static void validateAttribute(String attributeName, Map<String, String> values, List<Validator> validators, boolean applyMandatory) throws ValidationException {
        LinkedList<ValidationError> errors = new LinkedList<ValidationError>();
        if (validators != null) {
            for (Validator validator : validators) {
                validator.setAttributeName(attributeName);
                if (validator instanceof MandatoryValidator) {
                    if (applyMandatory) {
                        ((MandatoryValidator)validator).check(values.get(attributeName));
                    }
                } else if (validator instanceof AbstractStringValidator) {
                    ((AbstractStringValidator)validator).check(values.get(attributeName));
                }
                errors.addAll(validator.getErrors());
            }
        }
        if (errors.size() > 0) {
            throw new ValidationException(errors);
        }
    }

    public static void validate(IItem item) throws ValidationException {
        ValidatorEngine.validate(item, true);
    }

    public static void validate(IItem item, boolean applyMandatory) throws ValidationException {
        ValidatorEngine.validate(item.getAttributes(), item.getItemDefinition().getValidators(), applyMandatory);
    }

    public static void validate(TreeIndexed<String> tree, Map<String, List<Validator>> validators, boolean applyMandatory) throws ValidationException {
        ValidatorEngine.validate(tree.getValues(), validators, applyMandatory);
    }

    public static void validate(Map<String, String> values, Map<String, List<Validator>> validators, boolean applyMandatory) throws ValidationException {
        LinkedList<ValidationError> errors = new LinkedList<ValidationError>();
        for (String attributeName : values.keySet()) {
            try {
                ValidatorEngine.validateAttribute(attributeName, values, validators.get(attributeName), applyMandatory);
            }
            catch (ValidationException e) {
                errors.addAll(e.getErrors());
            }
        }
        if (errors.size() > 0) {
            throw new ValidationException(errors);
        }
    }
}

