/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item.attribute.validator;

import java.util.Arrays;
import java.util.List;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.AbstractStringFormatValidator;
import org.bonitasoft.web.toolkit.client.ui.utils.ListUtils;

public class FileExtensionAllowedValidator
extends AbstractStringFormatValidator {
    private final List<String> extensions;

    public FileExtensionAllowedValidator(String ... extensions) {
        super(FileExtensionAllowedValidator.makeRegexp(extensions));
        this.extensions = Arrays.asList(extensions);
    }

    private static String makeRegexp(String[] extensions) {
        StringBuilder sb = new StringBuilder();
        for (String extension : extensions) {
            sb.append(extension).append("|");
        }
        return "\\.(" + sb.substring(0, sb.length() - 1) + ")$";
    }

    @Override
    protected String defineErrorMessage() {
        return AbstractI18n.t_("%attribute% file format is not allowed. Only %file_formats% files are allowed.", new Arg("file_formats", ListUtils.join(this.extensions, ", ", " " + AbstractI18n.t_("or") + " ", "\".", "\"")));
    }
}

