/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.bonitasoft.console.common.server.auth.AuthenticationFailedException;
import org.bonitasoft.console.common.server.auth.AuthenticationManager;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerFactory;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerNotFoundException;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.login.LoginFailedException;
import org.bonitasoft.console.common.server.login.PortalCookies;
import org.bonitasoft.console.common.server.login.credentials.Credentials;
import org.bonitasoft.console.common.server.login.credentials.StandardCredentials;
import org.bonitasoft.console.common.server.login.credentials.UserLogger;
import org.bonitasoft.console.common.server.login.filter.TokenGenerator;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.exception.TenantStatusException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LoginManager.class.getName());
    protected TokenGenerator tokenGenerator = new TokenGenerator();
    protected PortalCookies portalCookies = new PortalCookies();

    public void login(HttpServletRequest request, HttpServletResponse response) throws AuthenticationManagerNotFoundException, LoginFailedException, TenantStatusException, AuthenticationFailedException, ServletException {
        HttpServletRequestAccessor requestAccessor = new HttpServletRequestAccessor(request);
        StandardCredentials userCredentials = this.createUserCredentials(requestAccessor);
        this.loginInternal(requestAccessor, response, this.getUserLogger(), userCredentials);
    }

    public void loginInternal(HttpServletRequestAccessor request, HttpServletResponse response, UserLogger userLoger, Credentials credentials) throws AuthenticationFailedException, ServletException, LoginFailedException {
        boolean invalidateAndRecreateHTTPSession;
        AuthenticationManager authenticationManager = this.getAuthenticationManager();
        Map<String, Serializable> credentialsMap = authenticationManager.authenticate(request, credentials);
        Boolean invalidateAndRecreateHTTPSessionIfSet = (Boolean)credentialsMap.remove("authentication.session.invalidate");
        boolean bl = invalidateAndRecreateHTTPSession = invalidateAndRecreateHTTPSessionIfSet == null || invalidateAndRecreateHTTPSessionIfSet != false;
        if (credentialsMap.isEmpty() && (credentials.getName() == null || credentials.getName().isEmpty())) {
            LOGGER.debug("There are no credentials in the request");
            throw new AuthenticationFailedException("No credentials in request");
        }
        APISession apiSession = this.loginWithAppropriateCredentials(userLoger, credentials, credentialsMap);
        this.storeCredentials(request, apiSession, invalidateAndRecreateHTTPSession);
        this.portalCookies.addCSRFTokenCookieToResponse(request.asHttpServletRequest(), response, this.tokenGenerator.createOrLoadToken(request.getHttpSession()));
    }

    protected StandardCredentials createUserCredentials(HttpServletRequestAccessor requestAccessor) {
        return new StandardCredentials(requestAccessor.getUsername(), requestAccessor.getPassword());
    }

    protected UserLogger getUserLogger() {
        return new UserLogger();
    }

    public AuthenticationManager getAuthenticationManager() throws ServletException {
        try {
            AuthenticationManager authenticationManager = AuthenticationManagerFactory.getAuthenticationManager();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using the AuthenticationManager implementation: " + authenticationManager.getClass().getName());
            }
            return authenticationManager;
        }
        catch (AuthenticationManagerNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private APISession loginWithAppropriateCredentials(UserLogger userLoger, Credentials credentials, Map<String, Serializable> credentialsMap) throws LoginFailedException {
        if (MapUtils.isEmpty(credentialsMap)) {
            LOGGER.debug("Engine login using the username and password");
            return userLoger.doLogin(credentials);
        }
        LOGGER.debug("Engine login using the map of credentials retrieved from the request");
        return userLoger.doLogin(credentialsMap);
    }

    protected void storeCredentials(HttpServletRequestAccessor request, APISession session, boolean recreateHTTPSession) throws LoginFailedException {
        String local = LocaleUtils.getUserLocaleAsString(request.asHttpServletRequest());
        User user = new User(request.getUsername(), local);
        this.initSession(request, session, user, recreateHTTPSession);
    }

    protected void initSession(HttpServletRequestAccessor request, APISession session, User user, boolean recreateHTTPSession) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("HTTP session initialization");
        }
        if (recreateHTTPSession) {
            request.getHttpSession().invalidate();
        }
        SessionUtil.sessionLogin(user, session, request.getHttpSession());
    }
}

