/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.bonitasoft.engine.api.PlatformAPIAccessor;
import org.bonitasoft.engine.api.PlatformLoginAPI;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.PlatformSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformLogoutServlet
extends HttpServlet {
    private static final long serialVersionUID = 739607235407639011L;
    protected final String PLATFORM_LOGIN_PAGE = "platformLogin.jsp";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PlatformLogoutServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logout(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logout(request, response);
    }

    protected void logout(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session;
        block4: {
            session = request.getSession();
            PlatformSession platformSession = (PlatformSession)session.getAttribute("platformSession");
            if (platformSession != null) {
                try {
                    PlatformLoginAPI platformLoginAPI = PlatformAPIAccessor.getPlatformLoginAPI();
                    platformLoginAPI.logout(platformSession);
                }
                catch (BonitaException e) {
                    if (!LOGGER.isErrorEnabled()) break block4;
                    LOGGER.error("Error while performing the logout", (Throwable)e);
                }
            }
        }
        session.removeAttribute("platformSession");
        session.invalidate();
        String redirectStr = request.getParameter("redirect");
        if (Boolean.parseBoolean(redirectStr)) {
            response.sendRedirect("platformLogin.jsp");
        }
    }
}

