/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.bonitasoft.console.common.server.page.CustomPageService;
import org.bonitasoft.console.common.server.page.PageContextHelper;
import org.bonitasoft.console.common.server.page.extension.PageResourceProviderImpl;
import org.bonitasoft.console.common.server.page.extension.RestAPIContextImpl;
import org.bonitasoft.engine.api.APIClient;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.extension.rest.RestAPIContext;
import org.bonitasoft.web.extension.rest.RestApiController;
import org.bonitasoft.web.extension.rest.RestApiResponse;
import org.bonitasoft.web.extension.rest.RestApiResponseBuilder;
import org.bonitasoft.web.rest.server.api.extension.ControllerClassName;
import org.bonitasoft.web.rest.server.api.extension.ResourceExtensionResolver;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RestApiRenderer.class.getName());
    private final CustomPageService customPageService = new CustomPageService();

    public RestApiResponse handleRestApiCall(HttpServletRequest request, ResourceExtensionResolver resourceExtensionResolver) throws CompilationFailedException, InstantiationException, IllegalAccessException, IOException, BonitaException {
        PageContextHelper pageContextHelper = new PageContextHelper(request);
        APISession apiSession = pageContextHelper.getApiSession();
        Long pageId = resourceExtensionResolver.resolvePageId(apiSession);
        Page page = this.customPageService.getPage(apiSession, pageId);
        PageResourceProviderImpl pageResourceProvider = new PageResourceProviderImpl(page);
        this.customPageService.ensurePageFolderIsUpToDate(apiSession, pageResourceProvider);
        ControllerClassName restApiControllerClassName = resourceExtensionResolver.resolveRestApiControllerClassName(pageResourceProvider);
        String mappingKey = resourceExtensionResolver.generateMappingKey();
        return this.renderResponse(request, apiSession, pageContextHelper, pageResourceProvider, restApiControllerClassName, mappingKey);
    }

    private RestApiResponse renderResponse(HttpServletRequest request, APISession apiSession, PageContextHelper pageContextHelper, PageResourceProviderImpl pageResourceProvider, ControllerClassName restApiControllerClassName, String mappingKey) throws CompilationFailedException, InstantiationException, IllegalAccessException, IOException, BonitaException {
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        GroovyClassLoader pageClassloader = this.customPageService.getPageClassloader(apiSession, pageResourceProvider);
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)pageClassloader);
            Class<?> restApiControllerClass = this.customPageService.registerRestApiPage(pageClassloader, pageResourceProvider, restApiControllerClassName, mappingKey);
            pageResourceProvider.setResourceClassLoader((ClassLoader)pageClassloader);
            try {
                RestApiResponse restApiResponse = this.doHandle(request, apiSession, pageContextHelper, pageResourceProvider, restApiControllerClass);
                return restApiResponse;
            }
            catch (Throwable e) {
                LOGGER.error("Error when executing rest api extension call to " + mappingKey, e);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
    }

    protected RestApiResponse doHandle(HttpServletRequest request, APISession apiSession, PageContextHelper pageContextHelper, PageResourceProviderImpl pageResourceProvider, Class<?> restApiControllerClass) throws InstantiationException, IllegalAccessException {
        RestApiController restApiController = (RestApiController)this.instantiate(restApiControllerClass);
        return restApiController.doHandle(request, new RestApiResponseBuilder(), (RestAPIContext)new RestAPIContextImpl(apiSession, new APIClient(apiSession), pageContextHelper.getCurrentLocale(), pageResourceProvider));
    }

    protected <T> T instantiate(Class<?> baseClass) throws InstantiationException, IllegalAccessException {
        return (T)baseClass.newInstance();
    }
}

