/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.preferences.properties;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.bonitasoft.console.common.server.preferences.properties.ConfigurationFilesManager;

public class ConsoleProperties {
    private static final String ATTACHMENT_MAX_SIZE = "form.attachment.max.size";
    private static final String IMAGE_UPLOAD_MAX_SIZE = "image.upload.max.size";
    private static final String CUSTOM_PAGE_DEBUG = "custom.page.debug";
    private static final String PAGE_LAST_UPDATE_CHECK_INTERVAL_MILLIS = "custom.page.lastupdate.database.check.interval.milliseconds";
    private static final int DEFAULT_PAGE_LAST_UPDATE_CHECK_INTERVAL_MILLIS = 3000;
    private static final String PROPERTIES_FILE = "console-config.properties";
    private static Map<String, Optional<String>> consoleProperties;

    public Properties getProperties() {
        return ConfigurationFilesManager.getInstance().getTenantProperties(PROPERTIES_FILE);
    }

    public long getMaxSize() {
        String maxSize = this.getProperty(ATTACHMENT_MAX_SIZE);
        if (maxSize != null) {
            return Long.valueOf(maxSize);
        }
        return 15L;
    }

    public long getImageMaxSizeInKB() {
        String maxSize = this.getProperty(IMAGE_UPLOAD_MAX_SIZE);
        if (maxSize != null) {
            return Long.valueOf(maxSize);
        }
        return 100L;
    }

    public boolean isPageInDebugMode() {
        String debugMode = this.getProperty(CUSTOM_PAGE_DEBUG);
        return Boolean.parseBoolean(debugMode);
    }

    public long getPageLastUpdateCheckInterval() {
        String pageLastUpdateCheckInterval = this.getProperty(PAGE_LAST_UPDATE_CHECK_INTERVAL_MILLIS);
        if (pageLastUpdateCheckInterval != null) {
            return Long.valueOf(pageLastUpdateCheckInterval);
        }
        return 3000L;
    }

    public String getProperty(String propertyName) {
        Optional<String> propertyValue;
        if (consoleProperties == null) {
            consoleProperties = new ConcurrentHashMap<String, Optional<String>>();
        }
        if ((propertyValue = consoleProperties.get(propertyName)) == null) {
            propertyValue = Optional.ofNullable(this.getProperties().getProperty(propertyName));
            consoleProperties.put(propertyName, propertyValue);
        }
        return propertyValue.orElse(null);
    }
}

