/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.bonitasoft.console.common.server.servlet.IconContent;
import org.bonitasoft.console.common.server.servlet.IconServlet;
import org.bonitasoft.engine.api.APIClient;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.identity.Icon;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.identity.UserNotFoundException;
import org.bonitasoft.engine.identity.UserUpdater;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMalformedUrlException;
import org.bonitasoft.web.toolkit.client.common.exception.http.ServerException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class OrganizationIconServlet
extends IconServlet {
    @Override
    protected Optional<IconContent> retrieveIcon(Long iconId, APISession apiSession) {
        Icon icon;
        IdentityAPI identityAPI = this.getIdentityApi(apiSession);
        try {
            icon = identityAPI.getIcon(iconId.longValue());
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
        return Optional.of(new IconContent(icon.getContent(), icon.getMimeType()));
    }

    @Override
    protected void deleteIcon(Long entityId, APISession apiSession, HttpServletRequest request) throws ServerException {
        String entityType = request.getParameter("type");
        if (entityType == null || !entityType.equals("user")) {
            throw new APIMalformedUrlException(request.getRequestURL().toString(), "Cannot delete a non-user icon. Provide type=user as a query parameter.");
        }
        IdentityAPI identityAPI = this.getIdentityApi(apiSession);
        UserUpdater updater = new UserUpdater();
        updater.setIcon(null, null);
        try {
            identityAPI.updateUser(entityId.longValue(), updater);
        }
        catch (UserNotFoundException e) {
            throw new APIItemNotFoundException(User.class.getName(), APIID.makeAPIID(entityId));
        }
        catch (UpdateException e) {
            throw new APIException(e);
        }
    }

    IdentityAPI getIdentityApi(APISession apiSession) {
        return new APIClient(apiSession).getIdentityAPI();
    }
}

