/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import java.io.File;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.bonitasoft.console.common.server.preferences.properties.ConfigurationFilesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CacheUtil.class.getName());
    protected static CacheManager CACHE_MANAGER = null;

    protected static synchronized CacheManager getCacheManager(String diskStorePath) {
        if (CACHE_MANAGER == null) {
            File cacheConfigFile = ConfigurationFilesManager.getInstance().getPlatformConfigurationFile("cache-config.xml");
            if (cacheConfigFile != null && cacheConfigFile.exists()) {
                Configuration configuration = ConfigurationFactory.parseConfiguration((File)cacheConfigFile);
                DiskStoreConfiguration diskStoreConfiguration = new DiskStoreConfiguration();
                diskStoreConfiguration.setPath(diskStorePath);
                configuration.addDiskStore(diskStoreConfiguration);
                CACHE_MANAGER = CacheManager.create((Configuration)configuration);
            } else {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Unable to retrieve the cache configuration file. Creating a cache manager with the default configuration");
                }
                CACHE_MANAGER = CacheManager.create();
            }
        }
        return CACHE_MANAGER;
    }

    protected static synchronized Cache createCache(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            cacheManager.addCache(cacheName);
            cache = cacheManager.getCache(cacheName);
        }
        return cache;
    }

    public static void store(String diskStorePath, String cacheName, Object key, Object value) {
        CacheManager cacheManager = CacheUtil.getCacheManager(diskStorePath);
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            cache = CacheUtil.createCache(cacheManager, cacheName);
        }
        Element element = new Element(key, value);
        cache.put(element);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("####Element " + key + " created in cache with name " + cacheName);
        }
    }

    public static Object get(String diskStorePath, String cacheName, Object key) {
        Serializable value = null;
        CacheManager cacheManager = CacheUtil.getCacheManager(diskStorePath);
        Cache cache = cacheManager.getCache(cacheName);
        if (cache != null) {
            Element element = cache.get(key);
            if (element != null) {
                value = element.getValue();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("####Element " + key + " found in cache with name " + cacheName);
                }
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("####Element " + key + " not found in cache with name " + cacheName);
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("####Cache with name " + cacheName + " doesn't exists or wasn't created yet.");
        }
        return value;
    }

    public static void clear(String diskStorePath, String cacheName) {
        CacheManager cacheManager = CacheUtil.getCacheManager(diskStorePath);
        Cache cache = cacheManager.getCache(cacheName);
        if (cache != null) {
            cache.removeAll();
        }
    }
}

