/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DocumentUtil {
    public static byte[] getArrayByte(InputStream input, int estimatedSize) throws IOException {
        ByteArrayOutputStream output;
        try (ByteArrayOutputStream byteArrayOutputStream = output = new ByteArrayOutputStream(estimatedSize);){
            int len;
            byte[] buf = new byte[8192];
            while ((len = input.read(buf)) >= 0) {
                output.write(buf, 0, len);
            }
        }
        return output.toByteArray();
    }

    public static byte[] getArrayByteFromFile(File f) throws IOException {
        long length = f.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File too big");
        }
        try (FileInputStream input = new FileInputStream(f);){
            byte[] byArray = DocumentUtil.getArrayByte(input, (int)length);
            return byArray;
        }
    }

    public static String sanitizeFilename(String filename) {
        if (filename != null) {
            return filename.replaceAll("[<>\"]+", "_").trim();
        }
        return null;
    }
}

