/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.bonitasoft.console.common.server.preferences.properties.ConfigurationFilesManager;
import org.bonitasoft.console.common.server.utils.TenantsManagementUtils;
import org.bonitasoft.engine.api.ApiAccessType;
import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.api.PlatformAPIAccessor;
import org.bonitasoft.engine.api.PlatformLoginAPI;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.platform.InvalidPlatformCredentialsException;
import org.bonitasoft.engine.session.PlatformSession;
import org.bonitasoft.engine.util.APITypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformManagementUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PlatformManagementUtils.class.getName());
    private final ConfigurationFilesManager configurationFilesManager = ConfigurationFilesManager.getInstance();

    boolean isLocal() throws UnknownAPITypeException, ServerAPIException, IOException {
        return ApiAccessType.LOCAL.equals((Object)APITypeManager.getAPIType());
    }

    PlatformAPI getPlatformAPI(PlatformSession platformSession) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getPlatformAPI((PlatformSession)platformSession);
    }

    PlatformLoginAPI getPlatformLoginAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getPlatformLoginAPI();
    }

    public PlatformSession platformLogin() throws BonitaException, IOException {
        if (this.isLocal()) {
            try {
                return this.localPlatformLogin();
            }
            catch (Exception e) {
                throw new ServerAPIException("Unable to login locally", (Throwable)e);
            }
        }
        String username = System.getProperty("org.bonitasoft.platform.username");
        String password = System.getProperty("org.bonitasoft.platform.password");
        try {
            return this.getPlatformLoginAPI().login(username, password);
        }
        catch (InvalidPlatformCredentialsException e) {
            throw new InvalidPlatformCredentialsException("The portal is not able to login to the engine because system properties org.bonitasoft.platform.username and org.bonitasoft.platform.password are not set correctly to the platform administrator credentials.\n These properties must be set when connecting to a Bonita engine that is not local. If the engine is local, change the connection to LOCAL using the APITypeManager");
        }
    }

    PlatformSession localPlatformLogin() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Class<?> api = Class.forName("org.bonitasoft.engine.LocalLoginMechanism");
        return (PlatformSession)api.getDeclaredMethod("login", new Class[0]).invoke(api.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
    }

    void platformLogout(PlatformSession platformSession) throws BonitaException {
        PlatformLoginAPI platformLoginAPI = this.getPlatformLoginAPI();
        platformLoginAPI.logout(platformSession);
    }

    private void retrieveTenantsConfiguration(PlatformAPI platformAPI) throws IOException {
        this.configurationFilesManager.setTenantConfigurationFiles(platformAPI.getClientTenantConfigurations());
    }

    private void retrievePlatformConfiguration(PlatformAPI platformAPI) throws IOException {
        Map clientPlatformConfigurations = platformAPI.getClientPlatformConfigurations();
        this.configurationFilesManager.setPlatformConfigurations(clientPlatformConfigurations);
    }

    public void initializePlatformConfiguration() throws BonitaException, IOException {
        PlatformSession platformSession = this.platformLogin();
        PlatformAPI platformAPI = this.getPlatformAPI(platformSession);
        this.retrievePlatformConfiguration(platformAPI);
        this.retrieveTenantsConfiguration(platformAPI);
        this.platformLogout(platformSession);
    }

    public void updateConfigurationFile(String file, byte[] content) throws IOException, BonitaException {
        PlatformSession platformSession = this.platformLogin();
        PlatformAPI platformAPI = this.getPlatformAPI(platformSession);
        platformAPI.updateClientTenantConfigurationFile(this.getDefaultTenantId(), file, content);
        this.platformLogout(platformSession);
    }

    long getDefaultTenantId() {
        return TenantsManagementUtils.getDefaultTenantId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Properties> getTenantConfigurations() throws IOException {
        HashMap<String, Properties> hashMap;
        PlatformSession platformSession = this.platformLogin();
        try {
            Map clientTenantConfigurations = this.getPlatformAPI(platformSession).getClientTenantConfigurations();
            HashMap<String, Properties> clientTenantConfigurationProperties = new HashMap<String, Properties>();
            for (Map.Entry entry : clientTenantConfigurations.entrySet()) {
                clientTenantConfigurationProperties.put((String)entry.getKey(), ConfigurationFilesManager.getProperties((byte[])entry.getValue()));
            }
            hashMap = clientTenantConfigurationProperties;
        }
        catch (Throwable throwable) {
            try {
                this.platformLogout(platformSession);
                throw throwable;
            }
            catch (BonitaException e) {
                throw new IOException(e);
            }
        }
        this.platformLogout(platformSession);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlatformAvailable() {
        boolean bl;
        PlatformSession platformSession = this.platformLogin();
        try {
            PlatformAPI platformAPI = PlatformAPIAccessor.getPlatformAPI((PlatformSession)platformSession);
            bl = platformAPI.isNodeStarted();
        }
        catch (Throwable throwable) {
            try {
                this.platformLogout(platformSession);
                throw throwable;
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Platform is not available.", (Throwable)e);
                } else if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Platform is not available.");
                }
                return false;
            }
        }
        this.platformLogout(platformSession);
        return bl;
    }
}

