/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.cases;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.process.ProcessInstanceNotFoundException;
import org.bonitasoft.engine.expression.ExpressionEvaluationException;
import org.bonitasoft.web.rest.server.FinderFactory;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.resource.Get;

public class ArchivedCaseContextResource
extends CommonResource {
    static final String ARCHIVED_CASE_ID = "archivedCaseId";
    private final ProcessAPI processAPI;
    private final FinderFactory resourceHandler;

    public ArchivedCaseContextResource(ProcessAPI processAPI, FinderFactory resourceHandler) {
        this.processAPI = processAPI;
        this.resourceHandler = resourceHandler;
    }

    @Get(value="json")
    public Map<String, Serializable> getArchivedCaseContext() throws ExpressionEvaluationException, ProcessInstanceNotFoundException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        Map caseExecutionContext = this.processAPI.getArchivedProcessInstanceExecutionContext(this.getArchivedCaseIdParameter());
        for (Map.Entry caseContextElement : caseExecutionContext.entrySet()) {
            resultMap.put((String)caseContextElement.getKey(), this.getContextResultElement((Serializable)caseContextElement.getValue()));
        }
        return resultMap;
    }

    private Serializable getContextResultElement(Serializable executionContextElementValue) {
        return this.resourceHandler.getContextResultElement(executionContextElementValue);
    }

    protected long getArchivedCaseIdParameter() {
        String caseId = this.getAttribute(ARCHIVED_CASE_ID);
        if (caseId == null) {
            throw new APIException("Attribute 'archivedCaseId' is mandatory in order to get the archived case context");
        }
        return Long.parseLong(caseId);
    }
}

