/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.web.rest.model.bpm.process.ProcessDefinition;
import org.bonitasoft.web.rest.model.bpm.process.ProcessItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.deployer.UserDeployer;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ProcessDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIProcess
extends ConsoleAPI<ProcessItem>
implements APIHasAdd<ProcessItem>,
APIHasUpdate<ProcessItem>,
APIHasGet<ProcessItem>,
APIHasSearch<ProcessItem>,
APIHasDelete {
    @Override
    protected ItemDefinition<ProcessItem> defineItemDefinition() {
        return ProcessDefinition.get();
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "name ASC";
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new ProcessDatastore(this.getEngineSession());
    }

    @Override
    @Deprecated(since="9.0.0")
    public ProcessItem add(ProcessItem item) {
        return this.getProcessDatastore().add(item);
    }

    @Override
    @Deprecated(since="9.0.0")
    public ProcessItem update(APIID id, Map<String, String> attributes) {
        return this.getProcessDatastore().update(id, (Map)attributes);
    }

    @Override
    public ProcessItem get(APIID id) {
        return this.getProcessDatastore().get(id);
    }

    @Override
    public ItemSearchResult<ProcessItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (filters.containsKey("team_manager_id") && filters.containsKey("supervisor_id")) {
            throw new APIException("Can't set those filters at the same time : team_manager_id and supervisor_id");
        }
        return this.getProcessDatastore().search(page, resultsByPage, search, orders, filters);
    }

    @Override
    public void delete(List<APIID> ids) {
        this.getProcessDatastore().delete(ids);
    }

    @Override
    protected void fillDeploys(ProcessItem item, List<String> deploys) {
        this.addDeployer(new UserDeployer(new UserDatastore(this.getEngineSession()), "deployedBy"));
        super.fillDeploys(item, deploys);
    }

    @Override
    protected void fillCounters(ProcessItem item, List<String> counters) {
        this.fillNumberOfFailedCasesIfFailedCounterExists(item, counters);
        this.fillNumberOfOpenCasesIfOpenCounterExists(item, counters);
    }

    private void fillNumberOfFailedCasesIfFailedCounterExists(ProcessItem item, List<String> counters) {
        if (counters.contains("failedCases")) {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("caller", "any");
            filters.put("processDefinitionId", item.getId().toString());
            filters.put("state", ProcessInstanceState.ERROR.name());
            item.setAttribute("failedCases", this.getCaseDatastore().count(null, null, filters));
        }
    }

    private void fillNumberOfOpenCasesIfOpenCounterExists(ProcessItem item, List<String> counters) {
        if (counters.contains("openCases")) {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("caller", "any");
            filters.put("processDefinitionId", item.getId().toString());
            item.setAttribute("openCases", this.getCaseDatastore().count(null, null, filters));
        }
    }

    protected ProcessDatastore getProcessDatastore() {
        return new ProcessDatastore(this.getEngineSession());
    }

    protected CaseDatastore getCaseDatastore() {
        return new CaseDatastore(this.getEngineSession());
    }
}

