/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.organization;

import java.util.Map;
import org.bonitasoft.engine.identity.CustomUserInfoValue;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.rest.model.identity.CustomUserInfoDefinition;
import org.bonitasoft.web.rest.model.identity.CustomUserInfoItem;
import org.bonitasoft.web.rest.server.api.APIPreconditions;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.organization.CustomUserInfoAttributeConverter;
import org.bonitasoft.web.rest.server.api.organization.CustomUserInfoConverter;
import org.bonitasoft.web.rest.server.datastore.converter.ItemSearchResultConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.filter.GenericFilterCreator;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.engineclient.CustomUserInfoEngineClient;
import org.bonitasoft.web.rest.server.engineclient.CustomUserInfoEngineClientCreator;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APICustomUserInfoValue
extends ConsoleAPI<CustomUserInfoItem>
implements APIHasSearch<CustomUserInfoItem>,
APIHasUpdate<CustomUserInfoItem> {
    private final CustomUserInfoEngineClientCreator engineClientCreator;
    private final CustomUserInfoConverter converter = new CustomUserInfoConverter();

    public APICustomUserInfoValue(CustomUserInfoEngineClientCreator engineClientCreator) {
        this.engineClientCreator = engineClientCreator;
    }

    @Override
    public ItemSearchResult<CustomUserInfoItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchResult<CustomUserInfoValue> result = this.getClient().searchCustomUserInfoValues(new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders), new Filters(filters, new GenericFilterCreator(new CustomUserInfoAttributeConverter()))).create());
        return new ItemSearchResultConverter<CustomUserInfoItem, CustomUserInfoValue>(page, resultsByPage, result, new CustomUserInfoConverter()).toItemSearchResult();
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "value ASC";
    }

    @Override
    public CustomUserInfoItem update(APIID id, Map<String, String> attributes) {
        APIPreconditions.check(APIPreconditions.containsOnly("value", attributes), new T_("Only the value attribute can be updated"));
        return this.converter.convert(this.getClient().setCustomUserInfoValue(id.getPartAsLong(1), id.getPartAsLong(0), attributes.get("value")));
    }

    private CustomUserInfoEngineClient getClient() {
        return this.engineClientCreator.create(this.getEngineSession());
    }

    @Override
    protected ItemDefinition<CustomUserInfoItem> defineItemDefinition() {
        return CustomUserInfoDefinition.get();
    }
}

