/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.organization;

import java.util.List;
import org.bonitasoft.engine.identity.Group;
import org.bonitasoft.engine.identity.GroupCriterion;
import org.bonitasoft.web.rest.model.identity.GroupDefinition;
import org.bonitasoft.web.rest.model.identity.GroupItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.organization.GroupDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIGroup
extends ConsoleAPI<GroupItem>
implements APIHasAdd<GroupItem>,
APIHasGet<GroupItem>,
APIHasDelete,
APIHasSearch<GroupItem>,
APIHasUpdate<GroupItem> {
    @Override
    protected ItemDefinition<GroupItem> defineItemDefinition() {
        return GroupDefinition.get();
    }

    @Override
    protected GroupDatastore defineDefaultDatastore() {
        return new GroupDatastore(this.getEngineSession());
    }

    @Override
    public String defineDefaultSearchOrder() {
        return GroupCriterion.NAME_ASC.toString();
    }

    @Override
    protected void fillDeploys(GroupItem item, List<String> deploys) {
        if (deploys.contains("parent_group_id") && item.getParentPath() != null && !item.getParentPath().isEmpty()) {
            Group parentGroup = ((GroupDatastore)this.getDefaultDatastore()).getGroupEngineClient().getGroupByPath(item.getParentPath());
            item.setParentGroupId(String.valueOf(parentGroup.getId()));
        }
    }

    @Override
    protected void fillCounters(GroupItem item, List<String> counters) {
        if (counters.contains("number_of_users")) {
            item.setAttribute("number_of_users", ((GroupDatastore)this.getDefaultDatastore()).getNumberOfUsers(item.getId()));
        }
    }
}

