/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.applicationmenu;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.business.application.ApplicationMenu;
import org.bonitasoft.engine.business.application.ApplicationMenuNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.applicationmenu.ApplicationMenuItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.applicationmenu.ApplicationMenuFilterCreator;
import org.bonitasoft.web.rest.server.datastore.applicationmenu.ApplicationMenuItemConverter;
import org.bonitasoft.web.rest.server.datastore.applicationmenu.ApplicationMenuSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ApplicationMenuDataStore
extends CommonDatastore<ApplicationMenuItem, ApplicationMenu>
implements DatastoreHasAdd<ApplicationMenuItem>,
DatastoreHasUpdate<ApplicationMenuItem>,
DatastoreHasGet<ApplicationMenuItem>,
DatastoreHasSearch<ApplicationMenuItem>,
DatastoreHasDelete {
    private final ApplicationAPI applicationAPI;
    private final ApplicationMenuItemConverter converter;

    public ApplicationMenuDataStore(APISession engineSession, ApplicationAPI applicationAPI, ApplicationMenuItemConverter converter) {
        super(engineSession);
        this.applicationAPI = applicationAPI;
        this.converter = converter;
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationMenuItem add(ApplicationMenuItem item) {
        try {
            ApplicationMenu applicationMenu = this.applicationAPI.createApplicationMenu(this.converter.toApplicationMenuCreator(item));
            return this.converter.toApplicationMenuItem(applicationMenu);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationMenuItem update(APIID id, Map<String, String> attributes) {
        try {
            ApplicationMenu applicationMenu = this.applicationAPI.updateApplicationMenu(id.toLong().longValue(), this.converter.toApplicationMenuUpdater(attributes));
            return this.converter.toApplicationMenuItem(applicationMenu);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ApplicationMenuItem get(APIID id) {
        try {
            ApplicationMenu applicationMenu = this.applicationAPI.getApplicationMenu(id.toLong().longValue());
            return this.converter.toApplicationMenuItem(applicationMenu);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            for (APIID id : ids) {
                this.applicationAPI.deleteApplicationMenu(id.toLong().longValue());
            }
        }
        catch (BonitaException e) {
            if (e.getCause() instanceof ApplicationMenuNotFoundException) {
                throw new APIItemNotFoundException("applicationmenu");
            }
            throw new APIException(e);
        }
    }

    protected ApplicationMenuSearchDescriptorConverter getSearchDescriptorConverter() {
        return new ApplicationMenuSearchDescriptorConverter();
    }

    @Override
    protected ApplicationMenuItem convertEngineToConsoleItem(ApplicationMenu item) {
        return new ApplicationMenuItemConverter().toApplicationMenuItem(item);
    }

    @Override
    public ItemSearchResult<ApplicationMenuItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator creator = this.makeSearchOptionCreator(page, resultsByPage, search, orders, filters);
        try {
            SearchResult<ApplicationMenu> searchResult = this.runSearch(creator);
            List appMenuItems = this.convertEngineToConsoleItemsList(searchResult.getResult());
            return new ItemSearchResult<ApplicationMenuItem>(page, resultsByPage, searchResult.getCount(), appMenuItems);
        }
        catch (SearchException e) {
            throw new APIException(e);
        }
    }

    protected SearchOptionsCreator makeSearchOptionCreator(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, this.getSearchDescriptorConverter()), new Filters(filters, new ApplicationMenuFilterCreator(this.getSearchDescriptorConverter())));
    }

    protected SearchResult<ApplicationMenu> runSearch(SearchOptionsCreator creator) throws SearchException {
        return this.applicationAPI.searchApplicationMenus(creator.create());
    }
}

