/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.process.ProcessCategoryItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ProcessCategoryDatastore
extends CommonDatastore<ProcessCategoryItem, Serializable>
implements DatastoreHasAdd<ProcessCategoryItem>,
DatastoreHasDelete {
    public ProcessCategoryDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    protected ProcessCategoryItem convertEngineToConsoleItem(Serializable item) {
        return null;
    }

    @Override
    public void delete(List<APIID> ids) {
        MapUtil.iterate(this.buildCategoriesIdByProcessIdMapping(ids), new MapUtil.ForEach<Long, List<Long>>(){

            @Override
            protected void apply(Long processId, List<Long> categoriesId) {
                ProcessCategoryDatastore.this.removeCategoriesFromProcess(processId, categoriesId);
            }
        });
    }

    private void removeCategoriesFromProcess(Long processId, List<Long> categoriesId) {
        try {
            this.getProcessAPI().removeCategoriesFromProcess(processId.longValue(), categoriesId);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private Map<Long, List<Long>> buildCategoriesIdByProcessIdMapping(List<APIID> ids) {
        HashMap<Long, List<Long>> categoriesIdByProcessId = new HashMap<Long, List<Long>>();
        for (APIID apiid : ids) {
            Long processId = apiid.getPartAsLong("process_id");
            Long categoryId = apiid.getPartAsLong("category_id");
            if (categoriesIdByProcessId.containsKey(processId)) {
                ((List)categoriesIdByProcessId.get(processId)).add(categoryId);
                continue;
            }
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(categoryId);
            categoriesIdByProcessId.put(processId, categoryIds);
        }
        return categoriesIdByProcessId;
    }

    @Override
    public ProcessCategoryItem add(ProcessCategoryItem item) {
        try {
            this.getProcessAPI().addCategoriesToProcess(item.getProcessId().toLong().longValue(), Collections.singletonList(item.getCategoryId().toLong()));
            return item;
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("This category has already been added to this process"), (Throwable)e);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    protected ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }
}

